/***************************************************************************
*        Copyright (C) 1986 by Douglas A. Young,
*        Kent State University, Kent Ohio
*        Unrestricted permission is granted to copy, modify
*        or redistribute this file.
*        Douglas A. Young phone: (415) 857-6478
*                         net  : dayoung@hplabs.hp.com
****************************************************************************/
/*************************************************************************
 *
 *   THE FUNCTION PLOT3D DISPLAYS A 3 DIMENSIONAL GRID ON THE TWO 
 *   DIMENSIONAL SCREEN. THE GRID IS PASSED TO THE FUNCTION FROM THE
 *   A LISP FUNCTION IN THE ARRAYS XPTS,YPTS,ZPTS. THE NUMBER OF
 *   POINTS IN THE GRID IS (NUMV * NUMU), AND THEREFORE THE NUMBER
 *   OF POLYGONS CREATED IS ( (NUMV -1) * (NUMU -1)). THIS IS 
 *   ARTIFICIALLY INCREASED BY DRAWING EACH POLYGON, WHICH IS BASICLY
 *   SQUARE, AS FOUR TRIANGLES. THE GRID IS TRANSFORMED BY A THREE-D
 *   TO 2-D PERSPECTIVE TRANSFORM AND ROTATED BY XANGLE,YANGLE,ZANGLE.
 *   THE RESULT IS DISPLAYED IN THE SCREEN BETWEEN XWMIN-XWMAX AND
 *   YWMIN-YWMAX. IF THE VARIABLE QHID IS TRUE THEN THE GRID IS
 *   DISPLAYED WITH HIDDEN LINES REMOVED. A DEPTH SORT ALGORITHM IS
 *   USED. THE POLYGON ARE SIMPLY SORTED ACORDING TO DEPTH, AND THEN DRAWN
 *   FROM THE MAXIMUM Z TO THE MINIMUM. THE POLYGONS ARE FILLED WITH
 *   WHITE BY THE FUNCTION FILL. THIS FUNCTION IS A QUICK AND DIRTY
 *   SCAN LINE FILL ALGORITHM, AND IS A GOOD CANDIDATE FOR IMPROVEMENT
 *************************************************************************/

#include <stdio.h>
#include <math.h>
#include <graphics.h>
#define TRUE 1
#define FALSE 0
#define WHITE 0
#define BLACK 15
#define max(A,B) ((A)>(B) ? (A):(B))
#define min(A,B) ((A)<(B) ? (A):(B))
typedef struct {
    double  x,
            y,
            z;
}               ARRAY_POINT;
typedef struct {
    ARRAY_POINT * p1, *p2, *p3, *p4;
    double  zmax;
}               POLY;
int     HIDDEN;
int PLOTSTYLE = 2;
plot3d (xpts, ypts, zpts, lowu, hiu, lowv, hiv, numu, numv, xangle,
    yangle, zangle, qhid, xwmin, ywmin, xwmax, ywmax, scr,style)
double  xpts[],
        ypts[],
        zpts[];
double  lowu,
        hiu,
        lowv,
        hiv;
int     numu,
        numv;
double  xangle,
        yangle,
        zangle;
int     qhid,
        xwmin,
        ywmin,
        xwmax,
        ywmax;
struct FORM *scr;
int style;
{
    register int    i,
                    j;
    register    ARRAY_POINT * data_ptr;
    int     point_number,
            NPT,
            NP;
    double  span;
    double  xx,
            yy,
            zz;
    ARRAY_POINT * datarray;
    POLY * polys, *polyslist;
    double
            u,
            v,
            lowx,
            hix,
            lowy,
            hiy,
            lowz,
            hiz,
            scalex,
            scaley,
            scalez,
            Cx,
            Cy,
            Cz,
            dview;
    double  rot[4][4];
    double  partu,
            partv,
            mag;
    int     xoffset,
            yoffset;
    HIDDEN = qhid;
/*    PLOTSTYLE = style; */
    lowx = hix = lowy = hiy = lowz = hiz = 0.0;
    if ((datarray = (ARRAY_POINT *) calloc ((unsigned int) numu * numv,
		    sizeof (ARRAY_POINT))) == NULL) {
	fprintf (stderr, "\nERROR calloc returned NULL\n");
	exit (1);
    }
    if ((polyslist = (POLY *) calloc ((unsigned int) (numu - 1) * (numv - 1),
		    sizeof (POLY))) == NULL) {
	fprintf (stderr, "\nERROR calloc returned NULL\n");
	exit (1);
    }
    polys = polyslist;
    data_ptr = datarray;
    NPT = (numv - 1) * (numu - 1);
    NP = numv * numu;
/*
  find function values for each grid point
*/
    point_number = 0;
    for (i = 0; i < numu * numv; i++) {
	xx = data_ptr -> x = xpts[i];
	yy = data_ptr -> y = ypts[i];
	zz = data_ptr -> z = zpts[i];
	if (i == 0) {
	    lowx = hix = xx;
	    lowy = hiy = yy;
	    lowz = hiz = zz;
	}
	else {
	    if (xx < lowx)
		lowx = xx;
	    if (xx > hix)
		hix = xx;
	    if (yy < lowy)
		lowy = yy;
	    if (yy > hiy)
		hiy = yy;
	    if (zz < lowz)
		lowz = zz;
	    if (zz > hiz)
		hiz = zz;
	}
	data_ptr++;
    }
    Cx = (hix + lowx) / 2.0;
    Cy = (hiy + lowy) / 2.0;
    Cz = (hiz + lowz) / 2.0;
    dview = (hix + hiy + hiz) * 4.0;
    getmatrix (rot, xangle, yangle, zangle, -Cx, -Cy, -Cz);
    transf (rot, dview, datarray, NP);
/* find max after rotation*/
    data_ptr = datarray;
    for (i = 0; i < numu; i++) {
	for (j = 0; j < numv; j++) {
	    if (i + j == 0) {
		lowx = hix = data_ptr -> x;
		lowy = hiy = data_ptr -> y;
		lowz = hiz = data_ptr -> z;
	    }
	    else {
		if (data_ptr -> x < lowx)
		    lowx = data_ptr -> x;
		if (data_ptr -> x > hix)
		    hix = data_ptr -> x;
		if (data_ptr -> y < lowy)
		    lowy = data_ptr -> y;
		if (data_ptr -> y > hiy)
		    hiy = data_ptr -> y;
		if (data_ptr -> z < lowz)
		    lowz = data_ptr -> z;
		if (data_ptr -> z < hiz)
		    hiz = data_ptr -> z;
	    }
	    data_ptr++;
	}
    }
    span = hix - lowx;
    if (span < hiy - lowy)
	span = hiy - lowy;
    normalize (datarray, lowx, lowy, lowz, span, NP);
/* find max after normalization*/
    data_ptr = datarray;
    for (i = 0; i < numu; i++) {
	for (j = 0; j < numv; j++) {
	    if (i + j == 0) {
		lowx = hix = data_ptr -> x;
		lowy = hiy = data_ptr -> y;
		lowz = hiz = data_ptr -> z;
	    }
	    else {
		if (data_ptr -> x < lowx)
		    lowx = data_ptr -> x;
		if (data_ptr -> x > hix)
		    hix = data_ptr -> x;
		if (data_ptr -> y < lowy)
		    lowy = data_ptr -> y;
		if (data_ptr -> y > hiy)
		    hiy = data_ptr -> y;
	    }
	    data_ptr++;
	}
    }
    xoffset = (int) ((xwmax - xwmin) * (1.0 - hix + lowx) / 2.0);
    yoffset = (int) ((ywmax - ywmin) * (1.0 - hiy + lowy) / 2.0);
    data_ptr = datarray + numv + 1;
    for (i = 0; i < numu - 1; i++) {
	for (j = 0; j < numv - 1; j++) {
	    save_poly (polys, ((data_ptr) - (1 + numv)), ((data_ptr) - (numv)),
		    data_ptr, ((data_ptr) - 1));
	    data_ptr++;
	    polys++;
	}
	data_ptr++;
    }
    if (HIDDEN)
	sortz (polyslist, NPT);
    polys = polyslist;
    print_poly (polys, NPT, xwmin, ywmin, xwmax, ywmax, xoffset, yoffset, scr);
}
getmatrix (rot, a, b, c, dx, dy, dz)
double  rot[4][4];
double  a,
        b,
        c,
        dx,
        dy,
        dz;
{
    double  sa,
            sb,
            sc,
            ca,
            cb,
            cc;
    double  rad = 57.2;
    double  sin (), cos ();
    sa = sin (a / rad);
    sb = sin (b / rad);
    sc = sin (c / rad);
    ca = cos (a / rad);
    cb = cos (b / rad);
    cc = cos (c / rad);
    rot[0][0] = cc * cb;
    rot[0][1] = sc * cb;
    rot[0][2] = -sb;
    rot[0][3] = rot[1][3] = rot[2][3] = 0.0;
    rot[1][0] = -sc * ca + sa * sb * cc;
    rot[1][1] = ca * cc + sa * sb * sc;
    rot[1][2] = cb * sa;
    rot[2][0] = sa * sc + ca * sb * cc;
    rot[2][1] = -cc * sa + sc * sb * ca;
    rot[2][2] = cb * ca;
    rot[3][0] = dz * rot[2][0] + dy * rot[1][0] + dx * rot[0][0] - dx;
    rot[3][1] = dy * rot[1][1] + dz * rot[2][1] + dx * rot[0][1] - dy;
    rot[3][2] = dz * rot[2][2] + dy * rot[1][2] - dx * sb - dz;
    rot[3][3] = 1.0;
}
transf (rot, dd, ptr, n)
double  rot[4][4];
double  dd;
ARRAY_POINT * ptr;
int     n;
{
    double  w,
            x,
            y,
            z;
    int     i;
    for (i = 0; i < n; i++) {
/* rotate the polygon
*/
	x = (ptr -> x) * rot[0][0] + (ptr -> y) * rot[1][0] + (ptr -> z) * rot[2][0];
	y = (ptr -> x) * rot[0][1] + (ptr -> y) * rot[1][1] + (ptr -> z) * rot[2][1];
	z = (ptr -> x) * rot[0][2] + (ptr -> y) * rot[1][2] + (ptr -> z) * rot[2][2];
	w = (ptr -> z) / dd + 1;
	ptr -> x = x / w;
	ptr -> y = y / w;
	ptr -> z = z / w;
	ptr++;
    }
}
normalize (ptr, lowx, lowy, lowz, span, n)
ARRAY_POINT * ptr;
double  lowx,
        lowy,
        lowz,
        span;
int     n;
{
    int     i;
    for (i = 0; i < n; i++) {
	ptr -> x = (ptr -> x - lowx) / span;
	ptr -> y = (ptr -> y - lowy) / span;
	ptr -> z = (ptr -> z - lowz) / span;
	ptr++;
    }
}
save_poly (polys, p1, p2, p3, p4)
POLY * polys;
ARRAY_POINT * p1, *p2, *p3, *p4;
{
/*
   put the points of a rectangle into a structure and compute the average
   depth of the rect
 */
    polys -> p1 = p1;
    polys -> p2 = p2;
    polys -> p3 = p3;
    polys -> p4 = p4;
    polys -> zmax = (p1 -> z + p2 -> z + p3 -> z + p4 -> z) / 4.0;
}
print_poly (polys, n, xwmin, ywmin, xwmax, ywmax, xoffset, yoffset, scr)
POLY * polys;
int     n,
        xwmin,
        ywmin,
        xwmax,
        ywmax,
        xoffset,
        yoffset;
struct FORM *scr;
{
    int     i,
            xx1,
            xx2,
            xx3,
            xx4,
            yy1,
            yy2,
            yy3,
            yy4;
/*
    draw all rectangles. If hidden lines option is chosen  fill the rectangles
    If a graphics package which offers filled polygons is used, eliminate
    the fill function used here and simply use the one the system provides.
 */
    for (i = 0; i < n; i++) {
	xx1 = (int) (polys -> p1 -> x * (xwmax - xwmin) + xwmin + xoffset);
	yy1 = (int) (polys -> p1 -> y * (ywmax - ywmin) + ywmin + yoffset);
	xx2 = (int) (polys -> p2 -> x * (xwmax - xwmin) + xwmin + xoffset);
	yy2 = (int) (polys -> p2 -> y * (ywmax - ywmin) + ywmin + yoffset);
	xx3 = (int) (polys -> p3 -> x * (xwmax - xwmin) + xwmin + xoffset);
	yy3 = (int) (polys -> p3 -> y * (ywmax - ywmin) + ywmin + yoffset);
	xx4 = (int) (polys -> p4 -> x * (xwmax - xwmin) + xwmin + xoffset);
	yy4 = (int) (polys -> p4 -> y * (ywmax - ywmin) + ywmin + yoffset);
	if (HIDDEN) {
	    if (yy1 <= yy4 && yy1 <= yy2)
		fill (xx1, yy1, xx2, yy2, xx3, yy3, xx4, yy4, scr);
	    else
	    if (yy2 <= yy1 && yy2 <= yy3)
		fill (xx2, yy2, xx3, yy3, xx4, yy4, xx1, yy1, scr);
	    else
	    if (yy3 <= yy4 && yy3 <= yy2)
		fill (xx3, yy3, xx4, yy4, xx1, yy1, xx2, yy2, scr);
	    else
	    if (yy4 <= yy1 && yy4 <= yy3)
		fill (xx4, yy4, xx1, yy1, xx2, yy2, xx3, yy3, scr);
	}
	vec (xx1, yy1, xx2, yy2, scr, BLACK);
	vec (xx2, yy2, xx3, yy3, scr, BLACK);
	vec (xx3, yy3, xx4, yy4, scr, BLACK);
	vec (xx4, yy4, xx1, yy1, scr, BLACK);
        if (PLOTSTYLE == 2){
        	vec (xx4, yy4, xx2, yy2, scr, BLACK);
        	vec (xx3, yy3, xx1, yy1, scr, BLACK);
        }
        else if (PLOTSTYLE == 3){
           vec((xx1+xx2)/2,(yy1+yy2)/2,(xx3+xx4)/2,(yy3+yy4)/2,scr,BLACK);
           vec((xx1+xx4)/2,(yy1+yy4)/2,(xx2+xx3)/2,(yy2+yy3)/2,scr,BLACK);
        }
	polys++;
    }
}
sortz (polys, n)
POLY polys[];
int     n;
{
    int     gap,
            i,
            j;
    POLY temp;
    for (gap = n / 2; gap > 0; gap /= 2)
	for (i = gap; i < n; i++)
	    for (j = i - gap; j >= 0 && polys[j].zmax > polys[j + gap].zmax; j -= gap) {
		temp = polys[j];
		polys[j] = polys[j + gap];
		polys[j + gap] = temp;
	    }
}

fill (xx1, yy1, xx2, yy2, xx3, yy3, xx4, yy4, scr)
int     xx1,
        yy1,
        xx2,
        yy2,
        xx3,
        yy3,
        xx4,
        yy4;
struct FORM *scr;
{
    static int  aa;

/* Pymin == xx1,yy1
   so in general the polygon configuration is
                 P1
          P4              P2
                P3
*/
    int     y,
            x,
            xmin,
            xmax,
            ymax;
    float   dxmax,
            dxmin,
            xl,
            xr;
    int     tempx,
            tempy;
    if(xx2 < xx4){
       tempx = xx2;
       xx2 = xx4;
       xx4 = tempx;
       tempy = yy2;
       yy2 = yy4;
       yy4 = tempy;
    }
    ymax = max (yy2, yy3);
    ymax = max (ymax, yy4);
    xmax = max (xx1, xx2);
    xmax = max (xmax, xx3);
    xmax = max (xmax, xx4);
    xmin = min (xx1, xx2);
    xmin = min (xmin, xx3);
    xmin = min (xmin, xx4);
/*
    case 1: small polygon <= 1 pixel
*/
    if (ymax == yy1 || xmin == xmax) {
	return (0);
    }
/* case 2:
                       P1
                   P2
                     P3
                            P4
*/
    else
    if (ymax == yy4) {

	if (yy1 != yy4)
	    dxmax = (float) (xx1 - xx4) / (float) (yy1 - yy4);
	else
	    dxmax = 0.0;
	if (yy1 != yy2)
	    dxmin = (float) (xx1 - xx2) / (float) (yy1 - yy2);
	else
	    dxmin = 0.0;
	xl = xr = (float) xx1;
	for (y = yy1; y < ymax; y++) {
	    if (y == yy2 && y != yy3) {
		xl = (float) xx2;
		if (yy2 != yy3)
		    dxmin = (float) (xx2 - xx3) / (float) (yy2 - yy3);
		else
		    dxmin = 0.0;
	    }
	    if (y == yy3) {
		xl = (float) xx3;
		if (yy3 != yy4)
		    dxmin = (float) (xx3 - xx4) / (float) (yy3 - yy4);
		else
		    dxmin = 0.0;
	    }

	    if ((int) (xl + 0.5) <= (int) (xr - 0.5))
		vec ((int) (xl + 0.5), (int) y, (int) (xr - 0.5), (int) y, scr, WHITE);
	    else if ((int) (xr + 0.5) <= (int) (xl - 0.5))
		vec ((int) (xr + 0.5), (int) y, (int) (xl - 0.5), (int) y, scr, WHITE);
	    xl = xl + dxmin;
	    xr = xr + dxmax;

	}

    }

/*
   case 3:
                      P1
                         P4
                        P3
                 P2
*/
    else
    if (ymax == yy2) {
	if (yy1 != yy4)
	    dxmax = (float) (xx1 - xx4) / (float) (yy1 - yy4);
	else
	    dxmax = 0.0;
	if (yy1 != yy2)
	    dxmin = (float) (xx1 - xx2) / (float) (yy1 - yy2);
	else
	    dxmin = 0.0;
	xl = xr = (float) xx1;
	for (y = yy1; y < ymax; y++) {
	    if (y == yy4 && y != yy3) {
		xr = (float) xx4;
		if (yy4 != yy3)
		    dxmax = (float) (xx4 - xx3) / (float) (yy4 - yy3);
		else
		    dxmax = 0.0;
	    }
	    if (y == yy3) {
		xr = (float) xx3;
		if (yy3 != yy2)
		    dxmax = (float) (xx3 - xx2) / (float) (yy3 - yy2);
		else
		    dxmax = 0.0;
	    }

	    if ((int) (xl + 0.5) <= (int) (xr - 0.5))
		vec ((int) (xl + 0.5), (int) y, (int) (xr - 0.5), (int) y, scr, WHITE);
	    else if ((int) (xr + 0.5) <= (int) (xl - 0.5))
		vec ((int) (xr + 0.5), (int) y, (int) (xl - 0.5), (int) y, scr, WHITE);
	    xl = xl + dxmin;
	    xr = xr + dxmax;
	}
    }
/*
    case 4:
                     P1
              P2             P4
                    P3
*/
    else
    if (ymax == yy3) {
	if (yy1 != yy2)
	    dxmin = (float) (xx1 - xx2) / (float) (yy1 - yy2);
	else
	    dxmin = 0.0;
	if (yy1 != yy4)
	    dxmax = (float) (xx1 - xx4) / (float) (yy1 - yy4);
	else
	    dxmax = 0.0;
	xl = xr = (float) xx1;
	for (y = yy1; y < ymax; y++) {
	    if (y == yy2 && y != yy3) {
		xl = (float) xx2;
		if (yy2 != yy3)
		    dxmin = (float) (xx2 - xx3) / (float) (yy2 - yy3);
		else
		    dxmin = 0.0;
	    }
	    if (y == yy4 && y != yy3) {
		xr = (float) xx4;
		if (yy4 != yy3)
		    dxmax = (float) (xx4 - xx3) / (float) (yy4 - yy3);
		else
		    dxmax = 0.0;
	    }
	    if ((int) (xl + 0.5) <= (int) (xr - 0.5))
		vec ((int) (xl + 0.5), (int) y, (int) (xr - 0.5), (int) y, scr, WHITE);
	    else if ((int) (xr + 0.5) <= (int) (xl - 0.5))
		vec ((int) (xr + 0.5), (int) y, (int) (xl - 0.5), (int) y, scr, WHITE);
	    xl = xl + dxmin;
	    xr = xr + dxmax;

	}
    }
    else
	fprintf (stderr, "Warning: hidden failure\n");

}
vec (xx1, yy1, xx2, yy2, scr, color)
int     xx1,
        yy1,
        xx2,
        yy2;
struct FORM *scr;
int     color;
{
    struct POINT    p1,
                    p2;
    struct BBCOM    bb;
    bb.srcform = (struct FORM  *) NULL;
    bb.destform = scr;
    bb.destrect.w = bb.destrect.h = 1;
    bb.cliprect.x = bb.cliprect.y = 0;/* */
    bb.cliprect.w = ScrWidth;
    bb.cliprect.h = ScrHeight;	/* */
    bb.halftoneform = (struct FORM *) NULL;/* no halftone */
    bb.destrect.x = xx1;
    bb.destrect.y = yy1;
    p2.x = xx2;
    p2.y = yy2;
    bb.rule = color;
    PaintLine (&bb, &p2);
}
