;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (C) 1986 by Douglas A. Young,
;;;        Kent State University, Kent Ohio
;;;        Unrestricted permission is granted to copy, modify
;;;        or redistribute this file.
;;;        Douglas A. Young phone: (415) 857-6478
;;;                         net  : dayoung@hplabs.hp.com
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; SELECT.L
;;;   syntax of the data base:
;;;
;;;                    screen      :(list of window-tables)
;;;                    window_table: list of expressions
;;;                    expression  : ymin ymax d_line
;;;                    d_line      : $D1..$D10.....etc
;;;            the d_line has a property <exp> attached
;;;                    exp         : list of elements
;;;                    element     :
;;;                (<extent> <number>)| (<extent><function-marker>)|(end)
;;;
;;;                    extent      : xmin xmax ymin ymax
;;;
;;;                    number      : ascii number of a character
;;;
;;;                    function    : integrate, matrix-r,matrix-l,exp,...
;;;       
;;;
;;;            
;;;     the window_table also has several properties:
;;;                               xmin xmax ymin ymax
;;;
;;;  To select a single object we first scan the screen for the window
;;;  the cursor is in.Then we get from the window_table the 
;;;  expression the location lies in -- then get the exp from the d_line
;;;  Search the list for the element surrounding the cursor location.
;;;  If the element is just an extent and a number, then the item is selected.
;;;  If the element consists of an extent and an function-marker, select all
;;;  items between the current marker and the next matching marker.
;;;
(eval-when (compile) (macsyma-module displa))
(load '//user//vaxima//young//displa//macros)
(declare
    (special **exptop** **expbot** **d-line** **in_matrix** **matrix_list**
	     **left_matrix** **sel-list** lg-character-y **current-window**
	     **whole-matrix** lg-character-x lg-character-x-2  *hit*
	     *front-end* *back-end* lg-character-y-2 *highlight-flag*))
;;;----------------------------------------------------------------
;;;This function returns the d-line in which the cursor lies
;;;---------------------------------------------------------------
(defun select-d-line (ymin ymax)
   (prog ( list)
      (setq list (get **current-window** 'd-lines))
      loop
      (cond((null list)(return nil)))
      (cond((and(>= ymax (caar list))
		    (<= ymin (cadar list)))
	    (setq **exptop** (caar list)
		  **expbot** (cadar list)
		  **d-line** (caddar list))
	    (return (caddar list))))
      (setq list (cdr list))
      (go loop)
      )
   )

;;;------------------------------------------------------------------
;;; select all expressions contained within the window
;;;------------------------------------------------------------------
(defun select (xmin ymin xmax  ymax)
   (setq **in_matrix** nil **matrix_list** nil **left_matrix** nil 
         *hit* nil *front-end* nil *back-end* nil *highlight-flag* t)
   (prog (result)
      (setq **sel-list**
	    (reverse(get (select-d-line ymin ymax) 'exp)))
      (setq result nil)
      ;;;
      ;;; if we're pointing at the "d-line" return the whole expression
      ;;;
      (cond((and(<= xmin (* 8 lg-character-x))
		    (select-d-line ymin ymax))
	    (on_highlight (get **current-window** 'xmin)
			  **expbot**
			  (get **current-window** 'xmax)
			  **exptop**)
	    (return
	       (mstring
		  (eval
		     (select-d-line ymin ymax)
		     )
		  )
	       )
	    )
		    )
      loop
      ;;;
      ;;; if we've gone through the whole list return the list of
      ;;; what we've found
      ;;;
      (cond((null **sel-list**)
	    (return  (strip(sublis reverse-greek result)))))
      ;;;
      ;;; Stuff to save the current matrix, in case we need a col,etc
      ;;;
      (cond((= 'd-matrix-l (caddddr(car **sel-list**)))
	    (setq **in_matrix** t **matrix_list** nil))
	       ((= 'd-matrix-r (caddddr(car **sel-list**)))
		(setq **in_matrix** nil
		      **matrix_list**
		      (append1 **matrix_list** (car **sel-list**)))
		))
      (cond(**in_matrix**
	      (setq **matrix_list**
		    (append1 **matrix_list** (car **sel-list**)))))
      ;;;
      ;;; if we happen to run through an  marker , ignore it
      ;;;
      (cond((= 1 (length (car **sel-list**)))
			     (cond( *hit* 
			           (setq *back-end* 
				          (append1 
					    *back-end*
					    (car **sel-list**)
					    )))
				    (t (setq *front-end* 
				          (append1  *front-end*
					   (car **sel-list**)))))
	    (setq **sel-list** (cdr **sel-list**))
	    (go loop)))
      ;;;
      ;;; check the x bounds-- if the max of the element
      ;;; is greater than the lower window bound, and the
      ;;; min of the element is less than the lower window bound
      ;;;

      (cond((and(<= xmin (cadar **sel-list**))
		    (>= xmax (caar **sel-list**)))
	    ;;;
	    ;;; if x bounds are a hit, check y bounds
	    ;;;
	    (cond((and(<= ymin (cadddar **sel-list**))
			  (>= ymax (caddar **sel-list**)))
		  (setq *hit* t)
		  ;;;
		  ;;; since this is now a hit, see if the item is a
		  ;;; function. If not, add it to the result.
		  ;;;
		  (cond((and **in_matrix**
			     (numberp (caddddr(car **sel-list**))))
			(return(sel_mat_rc xmin xmax ymin ymax)))
			     ((numberp (caddddr(car **sel-list**)))
			      (on_highlight (caar **sel-list**)
					    (caddr (car **sel-list**))
					    (cadr (car **sel-list**))
					    (cadddr (car **sel-list**)))
			      (setq result
				    (append
				       result
				       (list(caddddr (car **sel-list**)))
				       )
				    **sel-list** (cdr **sel-list**))

			      (go loop))
			     ;;;
			     ;;; if it is a function,call apropriate
			     ;;; function
			     ;;;
			     (t(setq result
				     (append result
					     (checkfunction)
					     )
				     )
				     (go loop)
				     )
		  )
		 )
			  ;;;
			  ;;; If no point is inside the window, go on moving
			  ;;; down the list
			  (t 
			     (cond( *hit* 
			           (setq *back-end* 
				          (append1 
					    *back-end*
					    (car **sel-list**)
					    )))
				    (t (setq *front-end* 
				          (append1  *front-end*
					  (car **sel-list**)
					     ))))
			     (setq **sel-list** (cdr **sel-list**))(go loop))))
		    (t 
			     (cond( *hit* 
			           (setq *back-end* 
				          (append1 
					    *back-end*
					    (car **sel-list**)
					    )))
				    (t (setq *front-end* 
				          (append1  *front-end*
					   (car **sel-list**)
					     ))))
		      (setq **sel-list** (cdr **sel-list**))(go loop))
		    )
      )
   )
    
(defun checkfunction ()
   (prog (list)
      ;;;
      ;;; if pointing at a left matrix
      ;;;
      (cond((= 'd-matrix-l (caddddr (car **sel-list**)))
	    (return (sel-matrix-l)))
	       ;;;
	       ;;; pointing at right side of matrix (ignored)
	       ;;;
	       ((= 'd-matrix-r (caddddr (car **sel-list**)))
		(return (sel-matrix-r)))
	       ;;;
	       ;;; if pointing to a divisor
	       ;;;
	       ((= 'd-hbar (caddddr (car **sel-list**)))
		(return (sel-divide)))
	       ;;;
	       ;;;   left side of absolute value
	       ;;;
	       ((= 'd-vbar-l (caddddr(car **sel-list**)))
		(return (sel-abs)))
	       ;;;
	       ;;;   right side of absolute (ignored)
	       ;;;
	       ((= 'd-vbar-r (caddddr(car **sel-list**)))
		(return (sel-abs-r)))
	       ;;;
	       ;;; sqrt function
	       ;;;
	       ((= 'd-sqrt (caddddr(car **sel-list**)))
		(return (sel-sqrt)))
	       ;;;
	       ;;; exponent
	       ;;;
	       ((= 'd-super (caddddr(car **sel-list**)))
		(return (sel-super)))
	       ;;;
	       ;;; subscript
	       ;;;
	       ((= 'd-subscript (caddddr(car **sel-list**)))
		(return (sel-subscript)))
	       ;;;
	       ;;; draw integral
	       ;;;
	       ((= 'd-integral1 (caddddr (car **sel-list**)))
		(return(sel-integral1)))
	       ((= 'd-integral2 (caddddr (car **sel-list**)))
		(return(sel-integral2)))
	       ((= 'd-limit (caddddr (car **sel-list**)))
		(return(sel-limit)))
	       ((= 'd-arrow (caddddr (car **sel-list**)))
		(return(sel-arrow)))
	       ((= 'd-deriv (caddddr(car **sel-list**)))
		(return(sel-deriv)))

	       ;;;
	       ;;; parenthesis
	       ;;;
	       ((= 'l-paren (caddddr (car **sel-list**)))
		(return (sel-l-paren)))
	       ((= 'r-paren (caddddr (car **sel-list**)))
		(return (sel-r-paren)))
	       ((= 'd-del (caddddr (car **sel-list**)))
		(return (sel-del)))
	       ;;;
	       ;;; default
	       ;;;
	       ((= 'd-sumsign (caddddr (car **sel-list**)))
		(return (sel-sum)))
	       ((= 'd-prod (caddddr (car **sel-list**)))
		(return (sel-prod)))
               ((= 'replacement-marker (caddddr (car **sel-list**)))
		(return (replacement-function)))
	       (t( princ '| unknown function |)(princ (car **sel-list**))
		   (setq **sel-list** (cdr **sel-list**))
		   (return nil)))
      )
   )
	       

 
(defun <= ( a b)
    (or(= a b)(lessp a b))
)
(defun >= ( a b)
    (or (= a b)(greaterp a b)))
;;;-----------------------------------------------------------
;;; sel-integral1 indefinite integral
;;;------------------------------------------------------------
(defun sel-integral1 ()
   (on_highlight (caar **sel-list**)
		 (caddr (car **sel-list**))
		 (cadr (car **sel-list**))
		 (cadddr (car **sel-list**)))
   (setq **sel-list** (cdr **sel-list**))
   ;;;
   ;;; return "integrate(string, string)"
   ;;;
   (append (list #/i #/n #/t #/e #/g #/r #/a #/t #/e 40.)
	   (sel-string t)(list #/,)
	   (cdr(sel-string t))(list 41.)))
;;;-----------------------------------------------------------
;;; sel-integral2 definite integral
;;;------------------------------------------------------------
(defun sel-integral2 ()
   (prog(string1 string2 string3 string4)
		 (on_highlight (caar **sel-list**)
			       (caddr (car **sel-list**))
			       (cadr (car **sel-list**))
			       (cadddr (car **sel-list**)))
		 (setq **sel-list** (cdr **sel-list**))
		 ;;;
		 ;;; return "integrate(string1, string2,string3, string4)"
		 ;;;
		 (setq string3 (sel-string t))
		 (setq string4 (sel-string t))
		 (setq string1 (sel-string t))
		 (setq string2 (cdr(sel-string t)))
		 (return(append (list #/i #/n #/t #/e #/g #/r #/a #/t #/e 40.)
				string1 (list #/,) string2 (list #/,)
				string3 (list #/,) string4 (list 41.)))))

;;;-----------------------------------------------------------
;;; sel-sum
;;;------------------------------------------------------------
(defun sel-sum ()
   (prog (string1 string2 string3 string4)
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))
      (setq **sel-list** (cdr **sel-list**))
      ;;;
      ;;; return "sum(string1, string2,string3,string4)"
      ;;;
      (setq string2 (sel-string t))
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))
      (setq **sel-list** (cdr **sel-list**))
      (setq string3 (sel-string t))
      (setq string4 (sel-string t))
      (setq string1 (sel-string t))
      (return (append (list #/s #/u #/m 40.)
		      string1 (list #/,)
		      string2 (list #/,)
		      string3 (list #/,)
		      string4 (list 41.)))))
;;;-----------------------------------------------------------
;;; sel-prod
;;;------------------------------------------------------------
(defun sel-prod ()
   (prog (string1 string2 string3 string4)
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))
      (setq **sel-list** (cdr **sel-list**))
      ;;;
      ;;; return "prod(string1, string2,string3,string4)"
      ;;;
      (setq string2 (sel-string t))
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))
      (setq **sel-list** (cdr **sel-list**))
      (setq string3 (sel-string t))
      (setq string4 (sel-string t))
      (setq string1 (sel-string t))
      (return(append (list #/p #/r #/o #/d 40.)
		     string1 (list #/,)
		     string2 (list #/,)
		     string3 (list #/,)
		     string4 (list 41.)))))
;;;--------------------------------------------------------------------
;;; sel-limit
;;;--------------------------------------------------------------------
(defun sel-limit ()
   (prog (string1 string2 string3 string4 string5)
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))
      (setq **sel-list** (cdr **sel-list**))
      ;;;
      ;;; return "limit(string1, string2,string3,string4)"
      ;;;
      (setq string2 (sel-string t))
      (setq string5 (sel-string t))
      (setq string3 (sel-string t))
      (setq string4 (sel-string t))
      (setq string1 (sel-string t))
      (cond ((= #/+ (car string4))(setq string4 (list #/p #/l #/u #/s)))
	    (t (setq string4 (list #/m #/i #/n #/u #/s))))
      (return(append (list #/l #/i #/m #/i #/t 40.)
		     string1 (list #/,)
		     string2 (list #/,)
		     string3 (list #/,)
		     string4 (list 41.)))))
;;;----------------------------------------------------------------
;;; sel-divide
;;;----------------------------------------------------------------
(defun sel-divide ()
   (prog (string1 string2)
      (setq **sel-list** (cdr **sel-list**))
      (setq string1 (sel-string t))
      (setq string2 (sel-string t))
      (cond((< 1 (length string1))
	    (setq string1 (append (list 40.) string1 (list 41.)))))
      (cond((< 1 (length string2))
	    (setq string2 (append (list 40.) string2 (list 41.)))))
      (return (append string1 (list #//) string2)))
   )
;;;----------------------------------------------------------------
;;; sel-abs
;;;----------------------------------------------------------------
(defun sel-abs ()
   (prog (dummy)
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))
      (setq **sel-list** (cdr **sel-list**))
      (setq dummy
	    (append (list #/a)(list #/b)(list #/s)
		    (list 40.)(sel-string t) (list 41.)
		    ))
      (setq **sel-list** (cdr **sel-list**))
      (return dummy)))
;;;----------------------------------------------------------------
;;; sel-sqrt
;;;----------------------------------------------------------------
(defun sel-sqrt ()
   (on_highlight (caar **sel-list**)
		 (caddr (car **sel-list**))
		 (cadr (car **sel-list**))
		 (cadddr (car **sel-list**)))
   (setq **sel-list** (cdr **sel-list**))
   (append (list #/s #/q #/r #/t)
	   (list 40.)(sel-string t) (list 41.)
	   ))
;;;---------------------------------------------------------------
;;; sel-del
;;;---------------------------------------------------------------
(defun sel-del ()
   (prog (string)
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))
      (setq **sel-list** (cdr **sel-list**))
      (setq string (sel-string t))
      (cond((= 1 (length string))(return (append (list #/d #/i #/f #/f)
						 (list 40.) string
						 (list 41.))))
	       (t(return (append (list #/d #/i #/f #/f) string))))
      ))

(defun sel-deriv ()
   (prog (result)
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))

      (setq result (cadddddr(car **sel-list**)))
      loop
      (cond((or(null **sel-list**)(equal (car **sel-list**) '(end-deriv)))
	    (setq **sel-list** (cdr **sel-list**))(return result))
		     (t(setq **sel-list** (cdr **sel-list**))(go loop)))
      (return result)))

;;;---------------------------------------------------------------
;;;
;;;----------------------------------------------------------------

 
;;;----------------------------------------------------------------
;;; sel-super -- exponent
;;;----------------------------------------------------------------
(defun sel-super ()
   (prog ( string)
      (setq **sel-list** (cdr **sel-list**))
      (setq string (sel-string t))
      (cond(( = 1 (length string))(return(append (list #/^) string)))
	      (t(return(append (list #/^)
			       (list 40.) string (list 41.))))))
   )

;;;----------------------------------------------------------------
;;; sel-super -- exponent
;;;----------------------------------------------------------------
(defun sel-subscript ()
    (setq **sel-list** (cdr **sel-list**))
    (append (list #/[)
	    (sel-string t) (list #/])
    ))
;;;---------------------------------------------------------------
;;; sel-matrix-l
;;;----------------------------------------------------------------
(defun sel-matrix-l ()
   (setq **left_matrix** t)
   (prog (rowcount colcount row col dummy)
      (setq row (caddddddar **sel-list**)
	    col (cadddddar **sel-list**))
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))
      (setq **sel-list** (cdr **sel-list**))
      (setq colcount 0 rowcount 1)
      loop1
      (cond((<= rowcount row)(set (intern(concat 'ROW rowcount)) nil)
	    (increment rowcount)(go loop1)))
      loopcol
      (cond((<= col colcount)(go end)))
      (setq rowcount row)
      looprow
      (cond((zerop rowcount)(increment colcount)(go loopcol)))
      (cond((null (eval (concat 'ROW rowcount)))
	    (set (concat 'row rowcount) (sel-string t)))
		  (t(set (concat 'ROW rowcount)
			 (append (eval(concat 'ROW rowcount))
				 (list #/,) (sel-string t)))))
      (setq rowcount (1- rowcount))
      (go looprow)
      end
      (setq rowcount 1)
      (setq dummy (list #/m #/a #/t #/r #/i #/x 40.))
      loop2
      (cond((< rowcount  row)
	    (setq dummy(append dummy (list #/[)
			       (eval(concat 'ROW rowcount))
			       (list #/])(list #/,)))
	    (increment rowcount)(go loop2))
	       ((= rowcount row)
		(setq dummy(append dummy (list #/[)
				   (eval(concat 'ROW rowcount))
				   (list #/])(list 41.)))
		(sel-matrix-r)
		(setq **left_matrix** nil)

		(return dummy))
	       (t(princ '| error in matrix|)))
      ))
;;;----------------------------------------------------------------
;;; sel-string t
;;;----------------------------------------------------------------
(defun sel-string  (highlight)
   (prog (dummy)
      (cond((= 'begin-list (caar **sel-list**))
	    (setq **sel-list** (cdr **sel-list**)))
	       (t(princ 'error)(return nil)))
      loop
      (cond((= (caar **sel-list**) 'end-list)
	    (setq **sel-list** (cdr **sel-list**))
	    (return dummy))
	       ((numberp (caddddr (car **sel-list**)))

		(setq dummy (append dummy (list(caddddr (car **sel-list**)))))
		(cond( highlight(on_highlight (caar **sel-list**)
					      (caddr (car **sel-list**))
					      (cadr (car **sel-list**))
					      (cadddr (car **sel-list**)))))
		(setq **sel-list** (cdr **sel-list**))
		(go loop))
	       (t(setq dummy (append dummy (checkfunction) ))
		       (go loop)))))
(defun sel-l-paren ()
   (prog (dummy)
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))
      (setq **sel-list** (cdr **sel-list**))
      (setq dummy
	    (append	(list 40.)(sel-string t) (list 41.)
			))
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))p
      (setq **sel-list** (cdr **sel-list**))
      (return dummy)))
;;;---------------------------------------------------------------
;;; dummy functions , just eat the element and go on
;;;---------------------------------------------------------------
(defun sel-abs-r ()
   (prog ()
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))
      (setq **sel-list**(cdr **sel-list**))
      (return nil)))
(defun sel-matrix-r ()
   (prog ()
      (cond(**left_matrix**
	      (on_highlight (caar **sel-list**)
			    (caddr (car **sel-list**))
			    (cadr (car **sel-list**))
			    (cadddr (car **sel-list**)))
	      (setq **sel-list**(cdr **sel-list**))
	      (return nil))
	      (t(setq **sel-list** (append **matrix_list** **sel-list**))
		      (return(sel-matrix-l))))))
      
(defun sel-r-paren ()
   (prog ()
      (setq **sel-list**(cdr **sel-list**))
      (return nil)))

    
(defun sel-arrow ()
   (prog ()
      (on_highlight (caar **sel-list**)
		    (caddr (car **sel-list**))
		    (cadr (car **sel-list**))
		    (cadddr (car **sel-list**)))
      (setq **sel-list**(cdr **sel-list**))
      (return nil)))
;;;------------------------------------------------------------
(defun sel_mat_rc (xmin xmax ymin ymax)
   (setq **whole-matrix** nil)
   (prog (rowcount colcount row col dummy hymin hymax hxmin hxmax
		   numbcol numbrow)
      (setq hxmin 2000
	    hxmax (caar **matrix_list**)
	    hymin (cadddar **matrix_list**)
	    hymax (caddar **matrix_list**)
	    numbrow 0
	    numbcol 0)
      (setq row (caddddddar **matrix_list**)
	    col (cadddddar **matrix_list**))
      (setq **sel-list** (append **matrix_list** **sel-list**))
      (setq **sel-list** (cdr **sel-list**))
      (setq colcount 1 rowcount 1)
      loop1
      (cond((<= rowcount row)(set (intern(concat 'ROW rowcount)) nil)
	    (increment rowcount)(go loop1)))
      loop2
      (cond((<= colcount col)(set (intern(concat 'COL colcount)) nil)
	    (increment colcount)(go loop2)))
      (setq colcount 1 rowcount 1)
      loopcol
      (cond((< col colcount)(go end)))
      (set (concat 'col colcount) (list (car(cadr **sel-list**))
					(cadr(cadr **sel-list**))))
      (setq rowcount row)
      looprow
      (cond((zerop rowcount)(increment colcount)(go loopcol)))
      (cond((null (eval (concat 'ROW rowcount)))
	    (set (concat 'row rowcount)
		 (list (caddr(cadr **sel-list**))
		       (cadddr(cadr **sel-list**))))
	    (sel-string nil))
		  (t (sel-string nil)))
      (setq rowcount (1- rowcount))
      (go looprow)
      end
      (setq colcount 1 rowcount 1 subfunc '($submatrix))
      loop4
      (cond((<= rowcount row)
	    (cond((or(> ymin (cadr (eval (concat 'ROW rowcount))))
			(< ymax (car (eval (concat 'ROW rowcount)))))
		  (setq subfunc (append1 subfunc rowcount)))
			(t(increment numbrow)
				     (cond((< (car (eval (concat 'row rowcount)))
					      hymin)
					   (setq hymin
						 (car (eval (concat 'row rowcount))))))
				     (cond((> (cadr (eval (concat 'row rowcount)))
					      hymax)
					   (setq hymax
						 (cadr (eval (concat 'row rowcount))))))

				     ))
	    (increment rowcount)(go loop4)))
      (setq subfunc (append1 subfunc  **d-line**))
      loop5
      (cond((<= colcount col)
	    (cond((or(> xmin (cadr (eval (concat 'col colcount))))
			(< xmax (car (eval (concat 'col colcount)))))
		  (setq subfunc (append1 subfunc colcount)))
			(t(increment numbcol)
				     (cond((< (car (eval (concat 'col colcount)))
					      hxmin)
					   (setq hxmin
						 (car (eval (concat 'col colcount))))))
				     (cond((> (cadr (eval (concat 'col colcount)))
					      hxmax)
					   (setq hxmax
						 (cadr (eval (concat 'col colcount))))))

				     ))

	    (increment colcount)(go loop5))
		)
      (cond((and(zerop numbcol)(zerop numbrow))(return nil)))
      (on_highlight hxmin hymin hxmax hymax)
      (cond((and ( = 1 numbcol)(= 1 numbrow))
	    (return(mstring(cadadr (eval subfunc))))))
      (return (mstring (eval subfunc)))
      )
   )


;;;------------------------------------------------------------------
;;; select all expressions contained within the window
;;;------------------------------------------------------------------
(defun select1()
   (prog (result)
      (setq *highlight-flag* nil)
      (setq **sel-list** (append *front-end* 
               '((555 555 555 555 replacement-marker)) *back-end*))
      (setq result nil)
      ;;;
      ;;; if we're pointing at the "d-line" return the whole expression
      ;;;
      clean
      (cond((equal (caddddr (car **sel-list**)) 'r-paren)
	          (setq **sel-list** (cdr **sel-list**)))
	       (t(setq **sel-list** (cdr **sel-list**))(go clean)))
      loop
      ;;;
      ;;; if we've gone through the whole list return the list of
      ;;; what we've found
      ;;;
      (cond((null **sel-list**)
	    (return (strip(sublis reverse-greek result)))))
      ;;;
      ;;; Stuff to save the current matrix, in case we need a col,etc
      ;;;
      (cond((= 'd-matrix-l (caddddr(car **sel-list**)))
	    (setq **in_matrix** t **matrix_list** nil))
	       ((= 'd-matrix-r (caddddr(car **sel-list**)))
		(setq **in_matrix** nil
		      **matrix_list**
		      (append1 **matrix_list** (car **sel-list**)))
		))
      (cond(**in_matrix**
	      (setq **matrix_list**
		    (append1 **matrix_list** (car **sel-list**)))))
      ;;;
      ;;; if we happen to run through an  marker , ignore it
      ;;;
      (cond((= 1 (length (car **sel-list**)))
	    (setq **sel-list** (cdr **sel-list**))
	    (go loop)))
      ;;;
      ;;; check the x bounds-- if the max of the element
      ;;; is greater than the lower window bound, and the
      ;;; min of the element is less than the lower window bound
      ;;;


      ;;; since this is now a hit, see if the item is a
      ;;; function. If not, add it to the result.
      ;;;
      (cond((and **in_matrix**
		 (numberp (caddddr(car **sel-list**))))
	    (return(sel_mat_rc xmin xmax ymin ymax)))
		 ((numberp (caddddr(car **sel-list**)))
		  (setq result
			(append
			   result
			   (list(caddddr (car **sel-list**)))
			   )
			**sel-list** (cdr **sel-list**))

		  (go loop))
		 ;;;
		 ;;; if it is a function,call apropriate
		 ;;; function
		 ;;;
		 (t(setq result
			 (append result
				 (checkfunction)
				 )
			 )
			 (go loop)
			 )
		 )
      )
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: REPLACEMENT
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Sat Apr 26 20:16:24 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun replacement-function  ()
   (prog ()
    (setq **sel-list** (cdr **sel-list**))
    (return (list **replacement-string**))
 ))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: TRIG_HACK
;;;   
;;;      Purpose: fix the reversed order of trig functions with exponents
;;;               a terrible hack
;;;      Written By: Douglas A. Young
;;;      Date: Thu May 08 19:41:40 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun trig_hack  (ll)
   (prog ( result exp)
      (return
	 (do*  ((a (pop ll)(pop ll)))
	       ((or(null ll)(>= 5 (length ll))) 
	              (if ll (setq result (append (reverse ll) 
		                                  (push a result))))
		      (reverse result))
	       (cond((and(equal a #/s)(equal (car ll) #/i)(equal (cadr ll) #/n)
				(not (equal (caddr ll) 40)))
		     (push a result)
		     (push  (pop ll) result)
		     (push  (pop ll) result)
		     (do ((temp (pop ll)(pop ll)))
			 ((equal (car ll) 40)(push temp exp))
			 (push temp exp))
		     (setq exp (reverse exp))
		     (do ((temp (pop ll)(pop ll)))
			 ((equal (car ll) 41)(push temp result)
			  (push (pop ll) result))
			 (push temp result))
		     (do ()
			 ((null exp))
			 (push (pop exp) result)))

		((and(equal a #/c)(equal (car ll) #/o)(equal (cadr ll) #/s)
					    (not (equal (caddr ll) 40)))
				 (push a result)
				 (push  (pop ll) result)
				 (push  (pop ll) result)
				 (do ((temp (pop ll)(pop ll)))
				     ((equal (car ll) 40)(push temp exp))
				     (push temp exp))
            		     (setq exp (reverse exp))	
				 (do ((temp (pop ll)(pop ll)))
				     ((equal (car ll) 41)(push temp result)
				      (push (pop ll) result))
				     (push temp result))
				 (do ()
				     ((null exp))
				     (push (pop exp) result)))

		((and(equal a #/t)(equal (car ll) #/a)(equal (cadr ll) #/n)
					    (not (equal (caddr ll) 40)))
				 (push a result)
				 (push  (pop ll) result)
				 (push  (pop ll) result)
				 (do ((temp (pop ll)(pop ll)))
				     ((equal (car ll) 40)(push temp exp))
				     (push temp exp))
		     (setq exp (reverse exp))				 
				 (do ((temp (pop ll)(pop ll)))
				     ((equal (car ll) 41)(push temp result)
				      (push (pop ll) result))
				     (push temp result))
				 (do ()
				     ((null exp))
				     (push (pop exp) result))
				 (push (pop exp) result))
		(a (push a result)))
	       )
	 )))



