/*********************************************************************************/
/*										 */
/* Gebrauch:  (a) CCC name [mod1 mod2 ... modn]                                  */
/*     oder:  (b) CCC name [mod1 mod2 ... modn] ___STRTPPEN    (entspricht CC)   */
/*     oder:  (c) CCC name [mod1 mod2 ... modn] ___DEBUGGER    (entspricht CCCg) */
/*										 */
/* Fall (a): Es wird nicht gestrippt und mit -g uebersetzt.                      */
/* Fall (b): Es wird gestrippt und nicht mit -g uebersetzt.                      */
/* Fall (c): Es wird nicht gestrippt und mit -g uebersetzt, und statt der        */
/*           SIMATH-Bibliotheken in 'modlib' werden die in 'deb' dazugebunden.   */
/*										 */
/*********************************************************************************/


# include <config.h>
# include <site.h>
# include <stdio.h>
# include <time.h>

# define                   platz( n,s ) ( s = malloc((n)*sizeof(char)), *s='\0' )
# define               strcat2( s,a,b ) ( *s='\0', strcat(strcat(s,a),b) )
# define             strcat3( s,a,b,c ) strcat( strcat2(s,a,b), c )
# define           strcat4( s,a,b,c,d ) strcat( strcat( strcat2(s,a,b), c), d)
# define         strcat5( s,a,b,c,d,e ) strcat( strcat( strcat(strcat2(s,a,b),c), d), e)
# define       strcat6( s,a,b,c,d,e,f ) strcat( strcat( strcat( strcat( strcat2(s,a,b),c), d), e), f)
# define     strcat7( s,a,b,c,d,e,f,g ) strcat(strcat( strcat( strcat( strcat( strcat2(s,a,b),c), d), e), f), g)

char *malloc(), *strcat();
FILE *fopen(), *fout;

zeit(fout)
FILE *fout;
{
	long l,*pl,time();
	struct tm *ptr,*localtime();
	int hour,min,sec;

	pl = &l;
	time(pl);
	ptr = localtime(pl);
	hour = ptr->tm_hour;
	min  = ptr->tm_min;
	sec  = ptr->tm_sec;
	fprintf(fout,"%d:%d%d:%d%d\n\n",hour,min/10,min%10,sec/10,sec%10);
	/* vorher: char *ctime();		              */
	/*	   pl = &l; time(pl); fprintf(fout,ctime(pl); */
}
	
char *C, *c, *name, *SM_pre, *SM_preV3_1;
char *MSG, *ERR;
char *name_c, *name_P;

main(argc,argv)
int argc;
char *argv[];
{
	int lauf,a,strip_sch=0,debug_sch=0;

/*** falsche Argumentliste abfangen ***/
	if ( argc == 1 ) {
		printf("\n***  usage: %s name [mod1, mod2, ... , modn]\n",argv[0]);
		printf(  "*** `name.S' is the source file.\n");
		printf(  "*** `%s/modlib/libmodi.a' is the i-th object library.\n\n",SM_HOME);
		exit(1);
	}
	if ( argc==2 && ( !strcmp(argv[1],"___STRIPPEN") || !strcmp(argv[1],"___DEBUGGER" ) ) ) {
		printf("\n***  usage: %s name [mod1, mod2, ... , modn] [___STRIPPEN | ___DEBUGGER]\n",argv[0]);
		printf(  "*** `name.S' is the source file.\n");
		printf(  "*** `%s/modlib/libmodi.a' is the i-th object library.\n\n",SM_HOME);
		exit(1);
	}

/*** evtl. Schalter zum Strippen oder zum Debuggen setzen ***/
	if ( !strcmp(argv[argc-1],"___STRIPPEN") ) { strip_sch=1; argc--; }
	else if ( !strcmp(argv[argc-1],"___DEBUGGER") ) {debug_sch=1; argc--; }

/*** Platz fuer die Strings allokieren ***/
	platz(100,name);
	platz(100,name_c);
	platz(100,name_P);
	platz(100,MSG);
	platz(100,ERR);
	platz(600,C);
	platz(1200,c);
	platz(300,SM_pre);
	platz(300,SM_preV3_1);

/*** Uebernahme der Eingabevariablen ***/
	name = *++argv;
	argv++;
	argc -= 2;

/*** COMP_MSG eroeffnen ***/
	strcat2( MSG, name, "_M" );
	fout = fopen( MSG , "w" );
	if ( fout == NULL ) {
		printf("Can't open `%s'.\n",MSG);
		exit(3);
	}

/*** COMP_ERR zusammenbauen ***/
	strcat2( ERR, name, "_CC" );

/*** Zusammensetzen der Steuerstrings ***/
	mkstring();
# ifdef ___MX
	if ( !debug_sch ) strcat3( c, "L=", SM_HOME, "/modlib/lib; " );
	else              strcat3( c, "L=", SM_HOME, "/deb/lib; " );
	if ( strip_sch )
	    strcat7( C, CC_SHORT_COMMAND, " -O -I. -I", SM_HOME, "/header -s -o ", name, ".x ", name_c );
	else
	    strcat7( C, CC_SHORT_COMMAND, " -O -I. -I", SM_HOME, "/header -o ", name, ".x ", name_c );
# else
	if ( strip_sch )
	    strcat7( c, CC_SHORT_COMMAND, " -O -I. -I", SM_HOME, "/header -s -o ", name, ".x ", name_c );
	else
	    strcat7( c, CC_SHORT_COMMAND, " -g -I. -I", SM_HOME, "/header -o ", name, ".x ", name_c );
	if ( !debug_sch ) strcat3( C, " -L", SM_HOME, "/modlib ");
	else              strcat3( C, " -L", SM_HOME, "/deb ");
# endif
	strcat(c,C);
	for ( lauf=1 ; lauf<=argc; lauf++ ) {
# ifdef ___MX
		strcat3( C, " ${L}", *argv++, ".a" );
# else
		strcat2( C, " -l", *argv++ );
# endif
		strcat(c,C);
	}
	strcat3( C, BIBLIOTHEKEN, " 2>", ERR );
	strcat(c,C);

/*** Starten Compile-Vorgang ***/
	fprintf(fout,"\nSM preprocessor started for \"%s\" at  ",name);
	zeit( fout );
	if ( !system(SM_pre) && !system(SM_preV3_1) ) {
		fprintf(fout,"\nSM preprocessor terminated correctly for \"%s\" at  ",name);
		zeit( fout );
		fprintf(fout,"\nCompiler started for \"%s\" at  ",name);
		zeit( fout );
		fclose(fout);           /* fout wird kurz geschlossen, damit  */
		a = system(c);          /* auch auf Apollo "2>" im Compilier- */
		fout = fopen(MSG,"a");  /* String c als Umlenkung von stderr  */
		if ( fout == NULL ) {   /* interpretiert wird.                */
			printf("Can't open `%s'.\n",MSG);
			exit(3);
		}
		if ( !a )  {
		    unlink(ERR);
# ifdef ___APOLLO
		    if ( strip_sch ) {
	                char strippen[100];
		        strcat3( strippen, "strip -Aa ", name, ".x" );
		        system(strippen);
		    }
# endif
		    fprintf(fout,"\nCompiler terminated correctly for \"%s\" at  ",name);
		}
		else  fprintf(fout,"\nCompiler terminated incorrectly for \"%s\" at  ",name);
	}
	else  fprintf(fout,"\nSM preprocessor terminated incorrectly for \"%s\" at  ",name);
	zeit( fout );
	if ( !debug_sch ) unlink(name_c);
	unlink(name_P);
	fclose( fout );
	strcat2( ERR, "cat ", MSG );
	system( ERR );
	unlink(MSG);
	exit(0);
}
mkstring()
{
	strcat2( name_c, name, ".c" );
	strcat2( name_P, name, ".P" );
	strcat5( SM_pre , SM_HOME, "/proz/preproc.x ", name, ".S ", name_P );
	strcat5( SM_preV3_1, SM_HOME, "/proz/preV3_1.x ", name_P, " ", name_c );
}
