#include "SM.h"

#define WS_ROW 20
#define	TEX_FILE_NAME	"develop"

#include "../header/config.h"

#include <ctype.h>
#include <fcntl.h>
#include <setjmp.h>
#include <signal.h>
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_SGTTY_H
#include <sgtty.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

/** Reaktion auf Eingabe von '^D' bei 'A', 'a', 'N', '?', '~/@', 'C', 'T'  **/
#ifdef ___APOLLO
#define CTRL_D {clearerr(stdin); break;}
#else						  /* else part of #ifdef ___APOLLO */
#define CTRL_D {clearerr(stdin); putchar('\n'); break;}
#endif

#define strcat2(s, a, b) (*s = '\0', strcat(strcat(s, a), b))
#define strcat3(s, a, b, c) strcat(strcat2(s, a, b), c)
#define strcat4(s, a, b, c, d) strcat(strcat(strcat2(s, a, b), c), d)
#define strcat5(s, a, b, c, d, e) strcat(strcat(strcat(strcat2(s, a, b), c), d), e)

#define gesetzt(var, name) \
if (!var[0]) {\
		printf("name undefined\n");\
		break;\
	    }
     
     
     void           *calloc(), *malloc();
     char           *strcat(), *getenv();	/*G*/
     
     jmp_buf         umgeb;
     
/******** zeit() ********/

zeit()
{
	long            l, *pl, time();
	struct tm      *ptr, *localtime();
	int             hour, min, sec;

	pl = &l;
	time(pl);
	ptr = localtime(pl);
	hour = ptr->tm_hour;
	min = ptr->tm_min;
	sec = ptr->tm_sec;
	printf("%d:%d%d:%d%d\n\n", hour, min / 10, min % 10, sec / 10, sec % 10);
	/* vorher: char *ctime(); */
	/* pl = &l; time(pl); puts(ctime(pl)); */
}



/******** abfang() ********/

void             abfang()		/*G int -> void	G*/
{
	signal(SIGINT, abfang);
	putchar('\n');
	longjmp(umgeb, 0);
}



/******** getline() ********/

char           *getline(s, n, pf)
	char           *s;
	int             n;
	FILE           *pf;
{
	char           *ss;
	char            ch;

	ss = s;
	while ((n--) > 0 && (ch = getc(pf)) != '\n' && ch != (char) EOF) /*G (char) */
		*s++ = ch;
	*s = '\0';
	if (*ss == '\0' && ch == (char) EOF)		/*G (char) */
		ss = NULL;
	return (ss);
}



int		DOC_STYLE = 0;
char		docstyle[10]; 		/*G*/

char            version_nr[20];
char            befehl[300];
char            modlibs[100][30];
char            LIB[900];
char            backup[400];
char            lib_long[200];

#ifdef ___DEBUGGER
char            lib_longg[200];
#endif

char            zeile[200];
char            helptxt[200];
char            lib[100];
char            name[100];
char            name_P[100], name_c[100], name_o[100];
char            name_S[100], name_i[100], name_x[100];

#ifdef ___DEBUGGER
char            PATH_deb[100];
#endif

char            PATH_header[100], PATH_modlib[100], PATH_dr[100], PATH_pre[100];
char            PATH_header_kant[100], PATH_modlib_kant[100];
char            PATH_preV3_1[100], PATH_CC[100];



char           *DIR[] = {AR_COMMAND, AR_SHORT_COMMAND, "tv", LIB, 0};



#ifndef ___DEBUGGER
char           *dir[] = {AR_COMMAND, AR_SHORT_COMMAND, "tv", lib_long, 0};
#ifdef I_HAVE_KANT
char           *obj[] = {CC_COMMAND, CC_SHORT_COMMAND, "-O", "-c", "-I.", PATH_header, PATH_header_kant, "-DPOSH", "-DKANT", "-D___KKK1", "-D___KKK2", name_c, 0};

#else						  /* else part of #ifdef I_HAVE_KANT */

char           *obj[] = {CC_COMMAND, CC_SHORT_COMMAND, "-O", "-c", "-I.", PATH_header, name_c, 0};
#endif

#else						  /* else part of #ifndef ___DEBUGGER */

char           *dir[] = {AR_COMMAND, AR_SHORT_COMMAND, "tv", lib_longg, 0};
#ifdef I_HAVE_KANT
char           *obj[] = {CC_COMMAND, CC_SHORT_COMMAND, "-g", "-c", "-I.", PATH_header, PATH_header_kant, "-DPOSH", "-DKANT", "-D___KKK1", "-D___KKK2", name_c, 0};

#else						  /* else part of #ifdef I_HAVE_KANT */

char           *obj[] = {CC_COMMAND, CC_SHORT_COMMAND, "-g", "-c", "-I.", PATH_header, name_c, 0};
#endif
#endif



#ifdef ___APOLLO
char           *strip[] = {STRIP_COMMAND, "strip", "-Aa", name_x, 0};

#else						  /* else part of #ifdef ___APOLLO */

char           *strip[] = {STRIP_COMMAND, "strip", name_x, 0};
#endif



#ifdef ___APOLLO
char           *pre[] = {CC_PRE_COMMAND, CC_PRE_SHORT_COMMAND, "-P", "-I.", PATH_header, name_c, 0};

#else						  /* else part of #ifdef ___APOLLO */

#ifdef I_HAVE_KANT
char           *pre[] = {CC_PRE_COMMAND, CC_PRE_SHORT_COMMAND, "-P", "-I.", PATH_header, PATH_header_kant, "-DPOSH", "-DKANT", "-D___KKK1", "-D___KKK2", name_c, 0};

#else						  /* else part of #ifdef I_HAVE_KANT */

char           *pre[] = {CC_PRE_COMMAND, CC_PRE_SHORT_COMMAND, "-P", "-I.", PATH_header, name_c, 0};
#endif
#endif



char           *r[] = {name_x, name_x, 0};
char           *lsv1[] = {"/bin/ls", "ls", "-l", name_S, 0};
char           *LPR[] = {PATH_dr, "dr", name_S, 0};



#ifdef ___APOLLO
char           *LPR1[] = {VI_COMMAND, VI_SHORT_COMMAND, "ce", name_i, 0};

#else						  /* else part of #ifdef ___APOLLO */

char           *LPR1[] = {VI_COMMAND, VI_SHORT_COMMAND, name_i, 0};
#endif



char           *SEL[] = {AR_COMMAND, AR_SHORT_COMMAND, "x", LIB, name_S, 0};
char           *DEL[] = {AR_COMMAND, AR_SHORT_COMMAND, "d", LIB, name_S, 0};
char           *AR[] = {AR_COMMAND, AR_SHORT_COMMAND, "r", LIB, name_S, 0};
char           *ARV1[] = {AR_COMMAND, AR_SHORT_COMMAND, "tv", LIB, name_S, 0};
char           *del[] = {AR_COMMAND, AR_SHORT_COMMAND, "d", lib_long, name_o, 0};



#ifdef ___DEBUGGER
char           *delg[] = {AR_COMMAND, AR_SHORT_COMMAND, "d", lib_longg, name_o, 0};
#endif



#ifdef ___APOLLO
char           *e[] = {VI_COMMAND, VI_SHORT_COMMAND, "ce", name_S, 0};

#else						  /* else part of #ifdef ___APOLLO */

char           *e[] = {VI_COMMAND, VI_SHORT_COMMAND, name_S, 0};
#endif



char           *E[] = {EMACS_COMMAND, EMACS_SHORT_COMMAND, name_S, 0};
char           *SM_pre[] = {PATH_pre, "preproc.x", name_S, name_P, 0};
char           *SM_preV3_1[] = {PATH_preV3_1, "preV3_1.x", name_P, name_c, 0};
char           *ar[] = {AR_COMMAND, AR_SHORT_COMMAND, "r", lib_long, name_o, 0};



#ifndef ___DEBUGGER
char           *arv1[] = {AR_COMMAND, AR_SHORT_COMMAND, "tv", lib_long, name_o, 0};

#else						  /* else part of #ifndef ___DEBUGGER */

char           *arg[] = {AR_COMMAND, AR_SHORT_COMMAND, "r", lib_longg, name_o, 0};
char           *arv1[] = {AR_COMMAND, AR_SHORT_COMMAND, "tv", lib_longg, name_o, 0};
#endif



#ifndef ___DEBUGGER
char           *ranlib[] = {RANLIB_COMMAND, "ranlib", lib_long, 0};

#else						  /* else part of #ifndef ___DEBUGGER */

char           *ranlib[] = {RANLIB_COMMAND, "ranlib", lib_longg, 0};
#endif



char           *C[100] = {PATH_CC, "CCC", name, 0};



#ifndef ___DEBUGGER
#ifdef I_HAVE_KANT
char           *c[200] = {CC_COMMAND, CC_SHORT_COMMAND, "-O", "-I.", PATH_header, PATH_header_kant, PATH_modlib, PATH_modlib_kant, "-DPOSH", "-DKANT", "-D___KKK1", "-D___KKK2", "-o", name_x, name_c, 0};
#define anz_args_c 15

#else						  /* else part of #ifdef I_HAVE_KANT */

char           *c[200] = {CC_COMMAND, CC_SHORT_COMMAND, "-O", "-I.", PATH_header, PATH_modlib, "-o", name_x, name_c, 0};
#define anz_args_c 9
#endif

#else						  /* else part of #ifndef ___DEBUGGER */

#ifdef I_HAVE_KANT
char           *c[200] = {CC_COMMAND, CC_SHORT_COMMAND, "-g", "-I.", PATH_header, PATH_header_kant, PATH_deb, PATH_modlib_kant, "-DPOSH", "-DKANT", "-D___KKK1", "-D_KKK2", "-o", name_x, name_c, 0};
#define anz_args_c 15

#else						  /* else part of #ifdef I_HAVE_KANT */

char           *c[200] = {CC_COMMAND, CC_SHORT_COMMAND, "-g", "-I.", PATH_header, PATH_deb, "-o", name_x, name_c, 0};
#define anz_args_c 9
#endif
#endif



#ifdef I_HAVE_KANT
char           *bibliotheken[] = {"-l_kern",
	"-l_ec4", "-l_arith4", "-l_pol4", "-l_matr3",
	"-l_ec3", "-l_arith3", "-l_pol3", "-l_matr2",
	"-l_ec2", "-l_arith2", "-l_pol2", "-l_matr1",
	"-l_pol1", "-l_ec1", "-l_arith1", "-l_list",
"-lKant2", "-lm", 0};

#else						  /* else part of #ifdef I_HAVE_KANT */

char           *bibliotheken[] = {"-l_kern",
	"-l_ec4", "-l_arith4", "-l_pol4", "-l_matr3",
	"-l_ec3", "-l_arith3", "-l_pol3", "-l_matr2",
	"-l_ec2", "-l_arith2", "-l_pol2", "-l_matr1",
	"-l_pol1", "-l_ec1", "-l_arith1", "-l_list",
"-lm", 0};
#endif




#define	NONE	0
#define	ASCII	1
#define	MAN	2
#define	TEX	3
#define	SOURCE	4
#define	DEVELOP	5
#define PREF	6
#define LIST	7

#define DefaultNamesDateiName	".SM.default"
#define NameTeX			"LaTeX"
#define NameMAN			"man"
#define NameASC			"ASCII"


/******** readDefaultNames() ********/

void            readDefaultNames()
{
	FILE           *datei;

	datei = fopen(DefaultNamesDateiName, "r");
	if (datei != NULL) {
		getline(LIB, 100, datei);
		getline(lib, 100, datei);
		getline(name, 100, datei);
		getline(docstyle, 100, datei);
	}
	if (*LIB != '\0')
		printf("\n current source library : %s", LIB);
	else
		printf("\n no source library");
	if (*lib != '\0') {
		strcat4(lib_long, SM_HOME, "/modlib/lib", lib, ".a");
#ifndef ___DEBUGGER
		printf("\n current object library : %s", lib_long);
#else
		strcat4(lib_longg, SM_HOME, "/deb/lib", lib, ".a");
		printf("\n current object library : %s", lib_longg);
#endif
	}
	else
		printf("\n no object library");
	if (*name != '\0')
		printf("\n current file name      : %s", name);
	else
		printf("\n no file name");

	if (*docstyle == '\0')	{
		printf ("\n no documentation style : using 'man'");
		sprintf (docstyle, NameMAN);
		DOC_STYLE = MAN;
		}
	else	{
		printf ("\n documentation style    : %s",docstyle);
		if (strcmp (docstyle, NameASC) == 0)	DOC_STYLE = ASCII;
		if (strcmp (docstyle, NameMAN) == 0)	DOC_STYLE = MAN;
		if (strcmp (docstyle, NameTeX) == 0)	DOC_STYLE = TEX;
		if (DOC_STYLE == NONE) {
			sprintf (docstyle, NameMAN);
			DOC_STYLE = MAN;
			}		
		}

	printf("\n\n\n");
	mkstring();
}



/******** writeDefaultNames() ********/

void            writeDefaultNames()
{
	FILE           *datei;

	datei = fopen(DefaultNamesDateiName, "w");
	if (datei != NULL) {
		fprintf(datei, "%s\n", LIB);
		fprintf(datei, "%s\n", lib);
		fprintf(datei, "%s\n", name);
		fprintf(datei, "%s\n", docstyle);
		chmod(DefaultNamesDateiName, 00777);
	}
	else
		printf("\nCan't open \"%s\".\n", DefaultNamesDateiName);
}



/******** VersionNumber() ********/

void            VersionNumber()
{
	FILE           *datei;
	char            datname[100];

	strcat2(datname, SM_HOME, "/header/config.h");
	datei = fopen(datname, "r");
	if (datei == NULL) {
		printf("Can't open \"%s\".\n", datname);
		exit(1);
	}

	do
		fgets(version_nr, 20, datei);
	while (strncmp(version_nr, "SIMATH-Version", 14));
	fscanf(datei, "%s", version_nr);

	fclose(datei);
}

char cmd[1000];
char cmd1[200], cmd2[200], cmd3[200];

char SM_PROZ[100];
char SM_DOKU[100];
char SM_EXEC[100];
char SM_SRC [100];
char SM_SH  [100];
char SM_LATEX[100];
char SM_TEX_TMP[100];
char SM_TMP[30];

char filename[100];
char filename2[100];
char filename3[100];


#define STODVI_STRING	"\
			cp %s/texdoc1.tex %s/%s.tex;\
			%s | %s/cut_doc T | %s/cmd TEX '%s' '%s' '%s' >> %s/%s.tex;\
			cat %s/texdoc2.tex >> %s/%s.tex;\
			cd %s;\
			latex %s.tex > %s.msg;\
			rm -f %s.aux %s.log"


#define AWK_STRING	"\
			awk \'{\
			FS = \"\\t\";\
			print \".IP \\\"\"$1\" \"$2\" \\t \"$3\"\\\"\\n\"$4;\
			 }\'"

/*	and this means
	awk '{FS = "\t"; print ".IP \""$1" "$2" \t "$3"\"\n"$4; }'
*/

/******** main() ********/

main()
{

	char            hilf[100];
	char           *sp, *terminal;	/*G getenv() global	G*/
	char           *eingabe, eingabe_feld[100];

	int             ent, GO = 1, lsschalter, name_c_loeschen, i, j;
	int             prompt = 1;

	signal(SIGINT, abfang);

	VersionNumber();

	sprintf (SM_PROZ,	"%s/proc",	SM_HOME);
	sprintf (SM_SH,		"%s/proc",	SM_HOME);
	sprintf (SM_EXEC,	"%s/proc",	SM_HOME);
	sprintf (SM_SRC,	"%s/sources",	SM_HOME);
	sprintf (SM_DOKU,	"%s/etc",	SM_HOME);
	sprintf (SM_LATEX,	"%s/etc",	SM_HOME);
	sprintf (SM_TMP,	"/tmp");
	sprintf (SM_TEX_TMP,	"%s/DOC_%d",SM_TMP,getpid());

	sprintf(cmd, "mkdir %s; chmod 777 %s", SM_TEX_TMP, SM_TEX_TMP);
	system(cmd);

	sprintf (filename,"%s/etc",SM_TEX_TMP);
	sprintf (filename2,"%s.2",filename);
	sprintf (filename3,"%s.3",filename);

	kopf();

	readDefaultNames();

	setjmp(umgeb);

	menue();

	while (GO) {


	if (prompt)
		printf(" < ");
	prompt = 1;

	eingabe = eingabe_feld;
	if (gets(eingabe) == NULL) {
		writeDefaultNames();

#ifndef ___APOLLO
		putchar('\n');
#endif
		printf("\n\n                    SM terminated at  ");
		zeit();
		printf("n");
		exit(2);
	}

	while ((ent = *eingabe++) != '\0') {

		if (isspace(ent))
			continue;

		switch (ent) {

		case 'P':
			gesetzt(name, file name);
			printf(" PRINT \"%s\"\n", name);
			my_system(LPR, 0, 0);
			break;

		case 'R':
			gesetzt(name, file name);
			printf(" RUN \"%s\"\n", name);
			my_system(r, 0, 0);
			break;

		case 'H':
			menue();
			break;

		case 27:
			break;	/* damit z.B. die Tasten MODE, PRINT, HELP und START keine doppelte
				 * Menueausgabe bewirken */

		case 'S':
			lsschalter = 'y';
			gesetzt(name, file name);
			gesetzt(LIB, source library);
			if (!access(name_S, F_OK)) {
				printf("\n \"%s\" already exists!\n\n ", name);
				my_system(lsv1, 0, 0);
				printf("\n overwrite? (y/n) ");
				while (isspace(lsschalter = getchar()));
				while (getchar() != '\n');	/* Eingabepuffer leeren */
				putchar('\n');
			}
			if (lsschalter == 'y')
				if (!my_system(SEL, 0, 0)) {
					printf(" \"%s\" extracted from \"%s\"\n", name, LIB);
					strcat2(hilf, "chmod 644 ", name_S);
					system(hilf);
				}
			break;

		case '_':
			gesetzt(name, file name);
			gesetzt(LIB, source library);
			if (!my_system(DEL, 0, 0))
				printf(" \"%s\" deleted from \"%s\"\n", name, LIB);
			break;

		case '*':
			lsschalter = 'y';
			gesetzt(name, file name);
			gesetzt(LIB, source library);
			if (access(name_S, F_OK)) {
				printf(" no file \"%s\"!\n", name_S);
				lsschalter = 'n';
			}
			if (lsschalter == 'y' && isinarchive(LIB, name_S)) {
				printf("\n \"%s\" already exists in \"%s\"!\n\n ", name, LIB);
				my_system(ARV1, 0, 0);
				printf("\n overwrite? (y/n) ");
				while (isspace(ent = *eingabe))
					eingabe++;
				if (ent == 'y' || ent == 'n') {
					lsschalter = ent;
					eingabe++;
					putchar('\n');
					putchar('\n');
				}
				else {
					while (isspace(lsschalter = getchar()));
					while (getchar() != '\n');	/* Eingabepuffer leeren */
					putchar('\n');
				}
			}

			if (lsschalter == 'y') {
				if (my_system(AR, 0, 0));	/* Fehlermeldung erfolgt von `ar'
								 * selbst */
				else {
					printf(" \"ar r %s %s\" done\n", LIB, name_S);
					unlink(name_S);
				}
			}
			break;

		case 'D':
			gesetzt(LIB, source library);
			my_system(DIR, 1, 0);
			break;

		case 'A':
			strcpy(backup, LIB);
			if (LIB[0] != '\0') {
				printf(" current source library : %s  ", LIB);
				printf("\n new source library     : ");
				if (gets(zeile) == NULL)
					CTRL_D;
			}
			else {
				printf(" source library : ");
				if (gets(zeile) == NULL)
					CTRL_D;
			}
			sscanf(zeile, "%s", LIB);
			if (LIB[0] == '\0')
				strcpy(LIB, backup);
			if (LIB[0] == '\'') {
				strcpy(backup, LIB + 1);
				strcat3(LIB, SM_HOME, "/sources/srclib.", backup);
			}
			mkstring();
			break;

		case 'o':
			gesetzt(name, file name);

			if (!access(name_c, F_OK)) {
				loesch_message(name_c);
				while (isspace(ent = *eingabe))
					eingabe++;
				if (ent == 'y' || ent == 'n') {
					name_c_loeschen = ent;
					eingabe++;
					putchar('\n');
					putchar('\n');
				}
				else {
					while (isspace(name_c_loeschen = getchar()));
					while (getchar() != '\n');	/* Eingabepuffer leeren */
					putchar('\n');
				}
				if (name_c_loeschen != 'y')
					break;
			}

			printf("\n SM preprocessor started at  ");
			zeit();
			if (!my_system(SM_pre, 0, 0) && !my_system(SM_preV3_1, 0, 0)) {
				printf("\n SM preprocessor terminated correctly at  ");
				zeit();
				printf("\n Compiler started at  ");
				zeit();
				if (!my_system(obj, 0, 0))
					printf("\n Compiler terminated correctly at  ");
				else
					printf("\n Compiler terminated incorrectly at  ");
			}
			else
				printf("\n SM preprocessor terminated incorrectly at  ");
			zeit();
#ifndef ___DEBUGGER
			unlink(name_c);
#endif
			unlink(name_P);
			break;

		case 'p':
			gesetzt(name, file name);

			if (!access(name_c, F_OK)) {
				loesch_message(name_c);
				while (isspace(ent = *eingabe))
					eingabe++;
				if (ent == 'y' || ent == 'n') {
					name_c_loeschen = ent;
					eingabe++;
					putchar('\n');
					putchar('\n');
				}
				else {
					while (isspace(name_c_loeschen = getchar()));
					while (getchar() != '\n');	/* Eingabepuffer leeren */
					putchar('\n');
				}
				if (name_c_loeschen != 'y')
					break;
			}
			printf("\n SM preprocessor started at  ");
			zeit();
			if (!my_system(SM_pre, 0, 0) && !my_system(SM_preV3_1, 0, 0)) {
				printf("\n SM preprocessor terminated correctly at  ");
				zeit();
				printf("\n C preprocessor started at  ");
				zeit();
				if (!my_system(pre, 0, 0)) {
/*G no more displaying .i file
					my_system(LPR1, 0, 0);
G*/
					printf("\n C preprocessor terminated correctly at  ");
					zeit();
				}
				else {
					printf("\n C preprocessor terminated incorrectly at  ");
					zeit();
				}
			}
			else {
				printf("\n SM preprocessor terminated incoreectly at  ");
				zeit();
			}
			unlink(name_c);
			unlink(name_P);

			/*
			 * unlink(name_o); 	unlink(name_i);
			 */

			break;

#ifdef ___DEBUGGER
		case '%':
			gesetzt(name, file name);

			if (!access(name_c, F_OK)) {
				loesch_message(name_c);
				while (isspace(ent =
					       *eingabe))
					eingabe++;
				if (ent == 'y' || ent == 'n') {
					name_c_loeschen =
						ent;
					eingabe++;
					putchar('\n');
					putchar('\n');
				}
				else {
					while
						(isspace(name_c_loeschen = getchar()));
					while (getchar() != '\n');

					/*
					 * Eingabepuffer leeren
					 */
					putchar('\n');
				}
				if (name_c_loeschen != 'y')
					break;
			}
			printf("\n SM preprocessor started at  ");
			zeit();
			if (!my_system(SM_pre, 0, 0) && !my_system(SM_preV3_1, 0, 0)) {
				printf("\n SM preprocessor terminated correctly at  ");
				zeit();
			}
			else {
				printf("\n SM preprocessor terminated incorrectly at  ");
				zeit();
			}
			unlink(name_P);

			break;
#endif

		case '-':
			gesetzt(name, file name);
			gesetzt(lib, object library);
			if (!my_system(del, 0, 0))
				printf(" \"%s\" deleted from \"%s\"\n", name, lib_long);
#ifdef ___DEBUGGER
			if (!my_system(delg, 0, 0))
				printf(" \"%s\" deleted from \"%s\"\n", name, lib_longg);
#endif
			break;

		case '+':
			lsschalter = 'y';
			gesetzt(name, file name);
			gesetzt(lib, object library);
			if (access(name_o, F_OK)) {
				printf(" no file \"%s\"!\n", name_o);
				lsschalter = 'n';
			}

#ifndef ___DEBUGGER
			if (lsschalter == 'y' && isinarchive(lib_long, name_o)) {
				printf("\n \"%s\" already exists in \"%s\"!\n\n ", name, lib_long);

#else				/* else part of #ifndef ___DEBUGGER */

			if (lsschalter == 'y' && isinarchive(lib_longg, name_o)) {
				printf("\n \"%s\" already exists in \"%s\"!\n\n ", name, lib_longg);
#endif
				my_system(arv1, 0, 0);
				printf("\n overwrite? (y/n) ");
				while (isspace(ent = *eingabe))
					eingabe++;
				if (ent == 'y' || ent == 'n') {
					lsschalter = ent;
					eingabe++;
					putchar('\n');
					putchar('\n');
				}
				else {
					while (isspace(lsschalter = getchar()));
					while (getchar() != '\n');	/* Eingabepuffer leeren */
					putchar('\n');
				}
			}

			if (lsschalter == 'y') {
				if (my_system(ar, 0, 0));	/* Fehlermeldung erfolgt von `ar'
								 * selbst */
				else {
					printf(" \"ar r %s %s\" done\n", lib_long, name_o);
#ifndef ___DEBUGGER
					unlink(name_o);
#endif
				}
			}

#ifdef ___DEBUGGER
			if (lsschalter == 'y') {
				if (my_system(arg, 0, 0));	/* Fehlermeldung erfolgt von `ar'
								 * selbst */
				else {
					printf(" \"ar r %s %s\" done\n", lib_longg, name_o);
					unlink(name_o);
				}
			}
#endif

			break;

		case 'a':
			strcpy(backup, lib);
			if (lib[0] != '\0') {
#ifndef ___DEBUGGER
				printf(" current object library : %s  ", lib_long);
				printf("\n new object library     : %s%s*.a ,", SM_HOME, "/modlib/lib");

#else				/* else part of #ifndef ___DEBUGGER */

				printf(" current object library : %s  ", lib_longg);
				printf("\n new object library     : %s%s*.a ,", SM_HOME, "/deb/lib");
#endif
				printf("\n                          * = ");
				if (gets(zeile) == NULL)
					CTRL_D;
			}
			else {
#ifndef ___DEBUGGER
				printf(" object library : %s%s*.a,", SM_HOME, "/modlib/lib");

#else				/* else part of #ifndef ___DEBUGGER */

				printf(" object library : %s%s*.a,", SM_HOME, "/deb/lib");
#endif
				printf("\n                  * = ");
				if (gets(zeile) == NULL)
					CTRL_D;
			}
			sscanf(zeile, "%s", lib);
			if (lib[0] == '.')
				lib[0] = '\0';
			else {
				if (lib[0] == '\0')
					strcpy(lib, backup);
				strcat4(lib_long, SM_HOME, "/modlib/lib", lib, ".a");
#ifdef ___DEBUGGER
				strcat4(lib_longg, SM_HOME, "/deb/lib", lib, ".a");
#endif
			}
			mkstring();
			break;

		case 'd':
			gesetzt(lib, object library);
			my_system(dir, 1, 0);
			break;

		case 'r':
			gesetzt(lib, object library);
			printf(" ranlib %s\n", lib_long);
			my_system(ranlib, 0, 0);
#ifdef ___DEBUGGER
			printf(" ranlib %s\n", lib_longg);
			my_system(ranlibg, 0, 0);
#endif
			break;

		case '!':
			*eingabe = '\0';	/*G*/
			printf(" >>> branching to a subshell\n");
			printf("     Type `CTRL/D' or \"exit\"");
			printf(" in order to return to SM.\n");
			system("$SHELL");
			break;

		case 'Q':
			writeDefaultNames();
			GO = 0;
			sprintf (cmd,"rm -rf %s",SM_TEX_TMP);
			system  (cmd);

			*eingabe = '\0';
			printf("\n\n                    SM terminated at  ");
			zeit();
			printf("\n");
			break;

		case 'e':
			gesetzt(name, file name);
			my_system(e, 0, 0);
			break;

		case 'E':
			gesetzt(name, file name);
			my_system(E, 0, 0);
			break;

		case 'c':
			gesetzt(name, file name);

			if (!access(name_c, F_OK)) {
				loesch_message(name_c);
				while (isspace(ent = *eingabe))
					eingabe++;
				if (ent == 'y' || ent == 'n') {
					name_c_loeschen = ent;
					eingabe++;
					putchar('\n');
					putchar('\n');
				}
				else {
					while (isspace(name_c_loeschen = getchar()));
					while (getchar() != '\n');	/* Eingabepuffer leeren */
					putchar('\n');
				}
				if (name_c_loeschen != 'y')
					break;
			}

			printf("\n SM preprocessor started at  ");
			zeit();
			if (!my_system(SM_pre, 0, 0) && !my_system(SM_preV3_1, 0, 0)) {
				printf("\n SM preprocessor terminated correctly at  ");
				zeit();
				printf("\n Compiler started at  ");
				zeit();
				if (!my_system(c, 0, 0)) {
#ifndef ___DEBUGGER
					my_system(strip, 0, 0);
#endif
					printf("\n Compiler terminated correctly at  ");
				}
				else
					printf("\n Compiler terminated incorrectly at  ");
			}
			else
				printf("\n SM preprocessor terminated incorrectly at  ");
			zeit();
#ifndef ___DEBUGGER
			unlink(name_c);
#endif
			unlink(name_P);
			break;

                case 'x' :			       
		case 'X' :	
			sprintf (cmd,"%s %s %s.dvi > /dev/null &",
				DVI_COMMAND, DVI_OPTIONS, TEX_FILE_NAME);
			system  (cmd);
			break;

	        case 't' :			
		case 'T' : 
			gesetzt(name, file name);

			sprintf (cmd, "./%s",name_S);

			if (access (cmd, F_OK)) {
				printf ("\n %s does not exist.\n\n", name_S);
				break;
				}

			comment (name, DEVELOP);
			break;

		case '?':
			key_index ();
			*eingabe = '\0';	/*G*/
			break;

		case '~' :
		case '@' :   			/*G*/
			if (*eingabe != '\0') 
				strcpy (helptxt,eingabe);
			else	{
				printf(" documentation of : ");
				if ( gets(zeile) == NULL ) CTRL_D
				sscanf(zeile, "%s", helptxt);
				}
			if (*helptxt != '\0' )  comment (helptxt, PREF);
			*eingabe = '\0';
			break;

		case 'C':
			gesetzt(name, file name);

			if (!access(name_c, F_OK)) {
				loesch_message(name_c);
				while (isspace(ent = *eingabe))
					eingabe++;
				if (ent == 'y' || ent == 'n') {
					name_c_loeschen = ent;
					eingabe++;
					putchar('\n');
					putchar('\n');
				}
				else {
					while (isspace(name_c_loeschen = getchar()));
					while (getchar() != '\n');	/* Eingabepuffer leeren */
					putchar('\n');
				}
				if (name_c_loeschen != 'y')
					break;
			}

			printf(" Press `RETURN' or enter additional object libraries ar1 ar2 ... .\n");
			printf(" Linking is done with ar1 as first library.\n : ");
			if (gets(zeile) == NULL)
				CTRL_D;
			getmodlibs(zeile);
			i = 3;
			if (lib[0])
				C[i++] = lib;
			for (j = 0; modlibs[j][0]; j++)
				C[i++] = modlibs[j];
#ifndef ___DEBUGGER
			C[i++] = "___STRIPPEN";

#else				/* else part of #ifndef ___DEBUGGER */

			C[i++] = "___DEBUGGER";
#endif
			C[i] = NULL;
			printf("\n Compiler started in the background at  ");
			zeit();
			my_system(C, 0, 1);
			break;

		case 'L':
			if (*eingabe < '1' || *eingabe > '3') {
				strcpy(backup, docstyle);
				printf(" current docu style :     %s\n", docstyle);
				printf(" new     docu style : (1) %s\n",NameASC);
				printf("                      (2) %s\n",NameMAN);
				printf("                      (3) %s\n",NameTeX);
				printf("                       ");

				if (gets(zeile) == NULL)
					CTRL_D;

				sscanf(zeile, "%s", docstyle);
				}
			else	*docstyle = *eingabe;

			*eingabe = '\0';

			switch (docstyle[0]) {
				case '1':	DOC_STYLE =  ASCII;
						strcpy (docstyle,NameASC);
						break;
				case '2':	DOC_STYLE =  MAN;
						strcpy (docstyle,NameMAN);
						break;
				case '3':	DOC_STYLE =  TEX;
						strcpy (docstyle,NameTeX);
						break;
				default:	strcpy(docstyle, backup);
				}
			printf("\n new     docu style :     %s\n\n", docstyle);

			break;

		case 'N':
			strcpy(backup, name);
			if (name[0] != '\0') {
				printf(" current file name : %s  ", name);
				printf("\n new file name     : ");
				if (gets(zeile) == NULL)
					CTRL_D;
			}
			else {
				printf(" file name : ");
				if (gets(zeile) == NULL)
					CTRL_D;
			}

			sscanf(zeile, "%s", name);
			if (name[0] == '\0')
				strcpy(name, backup);
			mkstring();
			break;

		case '$':
			system(eingabe);
			*eingabe = '\0';
			break;

		default:
			*eingabe = '\0';	/*G*/
			menue();
			break;
			}
		}
	}
	/** Cursor an richtigen Platz setzen **/
	printf(" %c", 8);
	exit(3);
}



/******** menu() ********/

menue()
{
	printf("   (N)AME :     (e,E)dit     (p)re        (o)bj        (c)omp       (C)comp\n");
	printf("   object :     (a)r name    (d)ir        ar(+)obj     ar(-)obj     (r)anlib\n");
	printf("   SOURCE :     (A)R NAME    (D)IR        AR(*)SRC     AR(_)SRC     (S)ELECT\n");
	printf("   (!)  (L) ($)  (?)  (~,@)  (P)RINT      (H)ELP       (R)UN        (Q)UIT   \n");
}



/******** kopf() ********/

kopf()
{
	printf("\n\n\n");

	printf("\n                         **************************           ");
	printf("\n                         *                        *           ");
	printf("\n                         *      S I M A T H       *           ");
	printf("\n                         *                        *           ");
	printf("\n                         **************************           ");
	printf("\n\n\n");
	printf("\n                      Version %s started at ", version_nr);
	zeit();
	printf("\n");
}



/******** mkstring() ********/

mkstring()
{
	int             i, j;
	static char     llib[100];

	strcat2(name_P, name, ".P");
	strcat2(name_c, name, ".c");
	strcat2(name_o, name, ".o");
	strcat2(name_S, name, ".S");
	strcat2(name_x, name, ".x");
	strcat2(name_c, name, ".c");
	strcat2(name_i, name, ".i");

	strcat3(PATH_header, "-I", SM_HOME, "/header");
	strcat3(PATH_modlib, "-L", SM_HOME, "/modlib");

#ifdef I_HAVE_KANT
	strcat2(PATH_modlib_kant, "-L", KANT_LIB);
	strcat2(PATH_header_kant, "-I", KANT_INCLUDE);
#endif

#ifdef ___DEBUGGER
	strcat3(PATH_deb, "-L", SM_HOME, "/deb");
#endif
	strcat2(PATH_dr, SM_HOME, "/proc/dr");
	strcat2(PATH_pre, SM_HOME, "/proc/preproc.x");
	strcat2(PATH_preV3_1, SM_HOME, "/proc/preV3_1.x");
	strcat2(PATH_CC, SM_HOME, "/proc/CCC");

	strcat2(llib, "-l", lib);
	i = anz_args_c;
	if (lib[0])
		c[i++] = llib;
	for (j = 0; bibliotheken[j]; j++)
		c[i++] = bibliotheken[j];
	c[i] = NULL;
}




/*G
	geloescht:

		FILE	*pfin, *pfout;
		FILE	*pf;
		static int      zaehl;

G*/


#include <sys/wait.h>



/******** my_system() ********/

int             my_system(command, flag, background)
	char          **command;
	int             flag, background;
{
	int             pid;
	union wait      status;
	int             i;
	int             retValue;

#ifdef TEST
	for (i = 0; command[i]; i++)
		fprintf(stderr, "my_system: %d.Argument: %s\n",
			i, command[i]);
#endif

	switch (pid = fork()) {
	case -1:
		perror("fork");
		retValue = (-1);
		break;
	case 0:
		command++;
		if (flag)
			page(command);
		else {
			/*
			 * Der folgende "Salto" ist noetig, damit beim Compilieren an Apollo-Consolen ('o',
			 * 'c', 't', 'C', 'T') Fehlermeldungen auf dem Bildschirm erscheinen und nicht
			 * verschluckt werden.
			 */
#ifdef ___APOLLO
			int             i;
			for (i = 3; i <= 20; i++)
				close(i);
#endif
			if (execv(command[-1], command)) {
				perror(command[-1]);
				exit(-1);
			}
		}
	default:
		if (background)
			retValue = 0;
		else {
			while (wait(&status) != pid);
			retValue = status.w_retcode;
		}

		break;
	}
	return (retValue);
}



/******** page() ********/

int             page(command)
	char           *command[];

{
	int             p[2];
	int             page_pid;

	if (pipe(p) < 0)
		return (0);
	switch (page_pid = fork()) {
	case 0:
		close(p[0]);
		close(1);
		dup(p[1]);
		close(p[1]);
		if (execv(command[-1], command)) {
			perror(command[-1]);
			return (-1);
		}
	case -1:
		return (-1);
	default:
		close(p[1]);
		close(0);
		dup(p[0]);
		close(p[0]);
		execl(PAGE_COMMAND, PAGE_SHORT_COMMAND, "-d", 0);
		perror("page");
		return (-1);
	}
}



#include <ar.h>

int             af;
char            b2[100];
struct ar_hdr   header;
int             erfolg;



/******** getheader() ********/

long            getheader()
{
	int             n;
	long            size;
	int             i = 15;

	while (b2[i] == ' ')
		i--;
	n = read(af, &header, sizeof(struct ar_hdr));
	if (n != sizeof(struct ar_hdr))
		return (0);
	sscanf(header.ar_size, "%ld", &size);
	if (!strncmp(header.ar_name, b2, i)) {
		erfolg = 1;
		return (0);
	}
	if (size & 1)
		size++;
	return (size);
}



/******** isinarchive() ********/

int             isinarchive(archive, member)
	char           *archive, *member;
{
	char            buf[BUFSIZ];
	long            pos;

	erfolg = 0;
	strcat2(b2, member, "                ");
	b2[16] = '\0';
	if ((af = open(archive, 0, 0)) < 0) {
#ifdef TEST
		perror(archive);
#endif
		return (0);
	}
	if ((read(af, buf, SARMAG) != SARMAG) || (strncmp(buf, ARMAG, 7))) {
		close(af);
		return (0);
	}
	while ((pos = getheader()) > 0) {
		lseek(af, pos, L_INCR);
	}
	close(af);
	return (erfolg);
}



/******** getmodlibs() ********/

int             getmodlibs(zeile)
	char           *zeile;
{
	char           *strtok();
	char           *p;
	static char    *sep = " \t\n";
	int             i;

	i = 0;
	modlibs[0][0] = 0;
	if (p = strtok(zeile, sep)) {
		strcpy(modlibs[i++], p);
		do {
			p = strtok(NULL, sep);
			if (p)
				strcpy(&modlibs[i++][0], p);
			else
				modlibs[i][0] = '\0';
		}
		while (p);
	}
}



/******** loesch_message() ********/

int             loesch_message(loesch_name)
	char            loesch_name[100];

{
	printf("\n File \"%s\" exists.\n", loesch_name);
	printf(" overwrite? (y/n) ");
}



/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char     sccsid[] = "@(#)strtok.c	5.8 (Berkeley) 2/24/91";
#endif						  /* LIBC_SCCS and not lint */

#if 0
#include <stddef.h>
#include <string.h>
#else
#define NULL 0
#endif

char           *
                strtok_spec(s, delim)
	register char  *s;
	register char  *delim;
{
	register char  *spanp;
	register int    c, sc;
	char           *tok;
	static char    *last;


	if (s == NULL && (s = last) == NULL)
		return (NULL);

	/*
	 * Skip (span) leading delimiters (s += strspn(s, delim), sort of).
	 */
cont:
	c = *s++;
	for (spanp = (char *) delim; (sc = *spanp++) != 0;) {
		if (c == sc)
			goto cont;
	}

	if (c == 0) {		/* no non-delimiter characters */
		last = NULL;
		return (NULL);
	}
	tok = s - 1;

	/*
	 * Scan token (scan for delimiters: s += strcspn(s, delim), sort of). Note that delim must have one
	 * NUL; we stop if we see that, too.
	 */
	for (;;) {
		c = *s++;
		spanp = (char *) delim;
		do {
			if ((sc = *spanp++) == c) {
				if (c == 0)
					s = NULL;
				else
					s[-1] = 0;
				last = s;
				return (tok);
			}
		} while (sc != 0);
	}
	/* NOTREACHED */
}


#define	TRUE	(0==0)
#define FALSE	(1==0)

#define WIN_COL_DEFAULT	80
#define	STR_SIZE	150


int	key_cnt = 0;				/* actual number of keys	*/
int	key_inv[10];				/* reverse search ?		*/
char	key[10][STR_SIZE];			/* string for use in printf	*/
char	KEY[10][STR_SIZE];			/* string for use in egrep	*/

key_index ()
 {
 FILE *pftmp;

 char	str[STR_SIZE],STR[STR_SIZE];
 char	c;
 int	i,del_key,Inv;
 int	anz;					/* number of matching lines	*/

 printf ("\n you entered the SM keyword index, type '?' for help\n");

 if (key_cnt != 0) 	list_keys();

 anz = get_num_keys ();

 while (1) {

   if (anz <= 0)
     printf("\n nothing found ");
   else
     printf("\n %d matches ", anz);
   
   printf("with %d key%s. ", key_cnt, (key_cnt == 1) ? "" : "s");
   printf("\n > ");
   
  overread:
  switch (getchar()) {

  case (' ') :
  case ('\t'):
	goto overread;
 
  case ('\n'):
	ungetc ('\n',stdin);

  default:
	printf ("\n type '?' for help\n");
	break;

  case ('0'):
	key_cnt = 0;
	anz = get_num_keys ();
	break;

  case ('~'):
  case ('@'):
	if (get_str (str,"documentation of"))	comment (str, PREF);
	break;

  case ('s'):
  case ('S'):
	if (get_str (str,"source of"))		comment (str, SOURCE);
	break;
	
  case ('.'):
	if (!get_str (str,"short description of"))	break;
	strcpy (STR,str);
	comment (STR, LIST);
	break;

  case ('+'):
	if (key_cnt == 9) {
		printf ("\n not more than 9 keys !\n");
		break;
		}

	if ((c = getchar()) == '!')
		Inv = 1;
	else	{
		Inv = 0;
		ungetc (c,stdin);
		}

	if (!get_str (str,(Inv == 0) ? "add key" : "add key  NOT  ")) break;

	if (*str == '!') {
		Inv = 1;
		strcpy (str,str+1);
		}

	if (format_STR (STR,str,Inv,1) == 0)	break;

	key_cnt++;
	strcpy (KEY[key_cnt],STR);
	strcpy (key[key_cnt],str);
	key_inv[key_cnt] = Inv;

	anz = get_num_keys ();
	list_keys ();
	break;

  case ('-'):
	if (key_cnt == 0) {
		printf ("\n there is no key you can delete!\n");
		break;
		}

	if (!get_str (str,"delete key nr")) 	break;

	del_key = (*str) - '0';

	if (del_key < 1 || del_key > key_cnt) {
		printf ("\n key (%d) is void:",del_key);
		list_keys ();
		break;
		}

	for (i = del_key; i < key_cnt; i++) {
		strcpy (key[i],key[i+1]);
		strcpy (KEY[i],KEY[i+1]);
		key_inv[i] = key_inv[i+1];
		}
	key_cnt--;
	printf (" key (%d) deleted:\n",del_key);

	anz = get_num_keys ();
	list_keys ();
	break;

  case ('c'):
  case ('C'):
	if (key_cnt == 0) {
		printf ("\n there is no key you can change!\n");
		break;
		}

	if (key_cnt == 1)
	if (ungetc (getchar(),stdin) == '\n') {
		del_key = 1;
		goto CHANGE;
		}

	if (!get_str (str,"change key nr")) break;

	del_key = (*str) - '0';

	if (del_key < 1 || del_key > key_cnt) {
		printf ("\n key (%c) is void:",*str);
		list_keys ();
		break;
		}

	CHANGE:
	sprintf (STR,"change key (%d) %s  to",del_key,key[del_key]);

	if (!get_str (str,STR))	break;

	Inv = 0;
	if (*str == '!') {
		Inv = 1;
		strcpy (str,str+1);
		}

	if (format_STR (STR,str,Inv,1) == 0)	break;

	strcpy (KEY[del_key],STR);
	strcpy (key[del_key],str);
	key_inv[del_key] = Inv;

	anz = get_num_keys ();
	list_keys ();
	break;

  case ('p'):
  case ('P'):
	printf ("\n");
	build_cmd (cmd,0);
	system (cmd);
	break;

  case ('q'):
  case ('Q'):
	printf ("\n returning to SM\n\n");
	while (getchar() != '\n');
	return (0);

  case ('l'):
  case ('L'):
	list_keys ();
	break;

  case ('?'):
	sprintf (str,"more %s/key.doc",SM_DOKU);
	system  (str);
	break;
	}
   while (getchar() != '\n');
   }  

 }


format_STR (STR,str,inv,relax)
char	*STR,*str;
int	inv,relax;
 {
 char *S,*s,hlp[STR_SIZE];

 if (strlen (str) == 0)	return (0);

 for (S = STR, s = str; *s != '\0'; ) 
	switch (*s) {
	case '*' :
	case '^' :
	case '.' :
	case '|' :	if (relax == 0 || isalnum (*s))	goto _default;
			if (*s == '*')	*(S++) = '.';
			*(S++) = *(s++);
			break;
	case '\'':	printf ("\n bad character '\n");
			*STR = '\0';
			return (0);
	default	 :	_default:
			if (!isalnum (*s))	*(S++) = '\\';
			*(S++) = *(s++);
			break;
		}

 *S = '\0';

 if (relax == 0)	return (1);

 if (*str == '|') {
	printf (" bad placed |\n");
	return (0);
	}

 strcpy (hlp,str);

 if (inv == 0)	sprintf (str,"      '%s",hlp);
 else		sprintf (str,"NOT   '%s",hlp);

 for (s = str; *s != '\0'; s++) {
	if (*s == '\t') {
		strcpy (hlp,s+1);
		strcpy (s,hlp);
		}
	if (*s == '|') {
		if (*(s+1) == '\0' || *(s+1) == '|') {
			printf (" bad placed |\n");
			return (0);
			}
		strcpy (hlp,s+1);
		sprintf (s,"'  OR  '%s",hlp);
		}
	}

 *s     = '\'';
 *(s+1) = '\0';

 return (1);
 }



get_str (str,msg)
char	*str,*msg;
 {
 if (ungetc (getchar(),stdin) == '\n')	{
		printf ("\n %s: ",msg);
		getchar();
		}
 getline (str,STR_SIZE/2,stdin);

 ungetc ('\n',stdin);

 return ((*str == '\0') ? FALSE : TRUE);
 }



exists (name,FUNC)	/* does SIMATH function 'name' exist?  A function exists iff	*/
char   *name;		/* its source (if any) contains a /*C or /*T comment		*/
int    FUNC;		/* exists as function (not a MACRO)				*/
 {
 FILE *fin;

 char cmd[1000],STR[30],*func;

 func = (FUNC == 1) ? "| egrep -v '(MACRO)'" : "";

 sprintf (cmd,"egrep '^%s\\\t' %s/KEYWORDS %s > %s ",name,SM_DOKU,func,filename);
 system  (cmd);

 if ((fin = fopen (filename,"r")) == NULL) {
	printf ("\n cannot open %s\n",filename);
	return (FALSE);
	}

 *STR = '\0';
 fscanf (fin,"%s",STR);
 fclose (fin);

 return ((*STR == '\0') ? FALSE : TRUE);
 }


get_size_of_win ()
 {
/*
 ioctl (filedes, TIOCGWINSZ, &win_groesse);
 return (win_groesse.ws_col);
*/
 return(80);
 }



build_cmd (cmd,count)
char	cmd[];
int	count;
 {
 int i,col;
 char *v,*c,*cnt,*name;
 char Key_w[50], str[1000];

 c = (count == 1) ? "-c" : "";				/* just count lines ?		*/
 sprintf (Key_w,"%s/KEYWORDS",SM_DOKU);			/* the KEYWORD file name	*/

 if (key_cnt == 0)
	sprintf (str,"  egrep %s '\t' %s",c,Key_w);
 else	{
	*str = '\0';
	for (i = 1; i<= key_cnt; i++)	{
		v 	= (key_inv[i] == 1) ? "-v" : "-i";	/* reverse search	*/
		cnt	= (i == key_cnt) ? c : "";		/* count lines ?	*/
		name	= (i ==  1 ) ? Key_w : "";		/* KEYWORD file name	*/
		sprintf (str,"%s| egrep %s %s '%s' %s",str,cnt,v,KEY[i],name);
		}
	}

/* str+2 as we have to delete the first 2 chars:	*/

 if (count==1)	sprintf (cmd,"%s > %s\n",str+2,filename3);
 else {	/*	
		col = get_size_of_win ();
		sprintf (cmd,"%s | %s/format_key %d | more",str+2,SM_EXEC,col-1);
	*/
		sprintf (cmd, "\
			%s | %s |\
			cat %s/tmac.s.override - |\
			nroff -ms | more -s",

			str+2, AWK_STRING,
			SM_DOKU);
		}

 return (0);
 }


get_num_keys ()
 {
 FILE *fin;

 int anz;

 build_cmd (cmd,1);
 system    (cmd);

 if ((fin = fopen (filename3,"r")) == NULL) {
	printf ("\n\n SM.get_num_keys:\n cannot open '%s' for reading\n\n",filename3);
	return (-1);
	}

 fscanf (fin,"%d",&anz);
 fclose (fin);
 return (anz);
 }



list_keys ()
 {
 int i;

 printf ("\n---------------------------------\n");
 if (key_cnt == 0)
	printf (" no keys selected\n");
 else	for (i = 1; i<=key_cnt; i++)	printf ("(%d)  %s\n",i,key[i]);

 printf ("---------------------------------\n");
 return (0);
 }




is_doku_written_in (c, src, out)
char c, *src, *out;
 {
 int fildes;
 int cnt;
 struct stat buf;

 sprintf (cmd,"%s/cut_doc %c < %s > %s", SM_SH, c, src, out);
 system  (cmd);

 if ((fildes = open (out,O_RDONLY)) == -1) {
	printf ("\n\n SM.is_doku_written_in '%c': cannot open '%s' for reading.\n\n",
		c, out);
	return (FALSE);
	}

 fstat (fildes, &buf);
 close (fildes);

 return (buf.st_size > 20);
 }




get_date_of_change (name, src, last_change)
char	*name, *src, *last_change;
 {
 FILE *pfin;

 *last_change = '\0';

 sprintf (cmd,"\
	grep '^   DATE %s' < %s | \
	awk '{ print $NF; }' | \
	awk -F\".\" '{ print $NF; }' > %s",
	name, src, filename2);

 system (cmd);

 if ((pfin = fopen (filename2,"r")) == NULL) {
	printf ("\n\n SM.get_date_of_change:\n cannot open '%s' for reading\n\n",filename3);
	return 0;
	}

 fscanf (pfin, "%s", last_change);
 fclose (pfin);

 return 0;
 }


get_srclib_name (srcname, libname)
char	*srcname, *libname;
 {
 char cmd[500];

 FILE *pfin;

 *libname = '\0';

 if (!exists (srcname,0)) 				return (TRUE);
 
 unlink (filename);

 sprintf (cmd,"\
	grep '^%s\\:' %s/INDEX | \
	awk -F: '{ print $2 }' > %s",
	srcname,SM_DOKU,filename);

 system  (cmd);

 if ((pfin = fopen (filename,"r")) == NULL)		return(FALSE);

 fscanf (pfin,"%s",libname);
 fclose (pfin);

 return (TRUE);
 }



#define SRCLIB_OFFSET	strlen ("srclib.")

comment (txt,style)
char txt[];	
int  style;
 {       
 char srclib_name[40];
 char last_change[10];
 int  doku_C, doku_T;

 switch (style) {
	case LIST:
	 	if (format_STR (cmd,txt,0,1) == 0) 	
			return (FALSE);

		if (!exists (cmd,0)) {
			printf ("\n%s: no such function/MACRO\n",txt);
			return (FALSE);
			}

		sprintf (cmd, "\
			%s < %s |\
			cat %s/tmac.s.override - |\
			nroff -ms | more -s",

			AWK_STRING, filename,
			SM_DOKU);

		system  (cmd);

		return (TRUE);

	case DEVELOP:
		
		sprintf (cmd,"\
			%s/cut_doc T < %s.S |\
			%s/cmd TEX '%s' '' '' > %s; \
			cat %s/texdoc1.tex %s %s/texdoc2.tex > %s.tex; \
			latex %s.tex",

			SM_SH, txt,
			SM_EXEC, getenv ("USER"), filename,
			SM_LATEX, filename, SM_LATEX, TEX_FILE_NAME,
			TEX_FILE_NAME);

		printf ("parsing to LaTeX...\n");

		system (cmd);

		sprintf (cmd,"\
			%s/cut_doc T < %s.S |\
			%s/cmd MAN '%s' '' '' > %s.man;\
			nroff -man < %s.man | ul -t %s| more -f -s",

			SM_SH, txt,
			SM_EXEC, getenv ("USER"), TEX_FILE_NAME,
			TEX_FILE_NAME, getenv ("TERM"));

		printf ("parsing to nroff...\n");

		system (cmd);

		sprintf (cmd,"\
			%s/cut_doc T < %s.S |\
			%s/cmd KEY '' '' ''",

			SM_SH, txt,
			SM_EXEC);

	 printf ("\n KEYWORD-entry is\n");
		system (cmd);

		return (TRUE);
	}

 if (format_STR (cmd,txt,0, 0) == 0)	return (0);

 if (!get_srclib_name (cmd, srclib_name)) {
	printf ("\n\n SM.comment: cannot open '%s' for reading.\n\n", filename);
	return (0);
	}

 if (*srclib_name == '\0') {
	printf ("\n %s : no such function\n\n", txt);
	return (0);
	}
	
/*
printf ("\n\n take %s from srclib '%s'\n",txt,srclib_name);
*/
 switch (style) {
	case PREF:
	case TEX:
	case MAN:
	case ASCII:
	case SOURCE:
		sprintf (cmd,"%s p %s/%s %s.S > %s",
			AR_SHORT_COMMAND,
			SM_SRC,	srclib_name, txt,
			filename);

		system (cmd);
	}

 doku_C = is_doku_written_in ('C',filename,filename2);
 doku_T = is_doku_written_in ('T',filename,filename3);
/*
printf ("\n docu style available is (C,T) = (%d,%d)\n",doku_C,doku_T);
*/
 if (style == PREF) 
 switch (DOC_STYLE) {
	case ASCII:
		style = ASCII;
		break;
	case MAN:
		if (doku_T)	style = MAN;
		else		style = ASCII;
		break;
	case TEX:
		if (doku_T)	style = TEX;
		else		style = ASCII;
		break;
	}

 switch (style) {
	case ASCII:
		if (!doku_T)	break;
	case TEX:
	case MAN:
		get_date_of_change (txt, filename, last_change);
	}


 switch (style) {
	case ASCII:	
		if (doku_T)
			sprintf (cmd,"\
				%s/cmd ASC '%s' '%s' '%s' < %s | more",

				SM_EXEC, srclib_name + SRCLIB_OFFSET, last_change, version_nr, filename3);
		else
			sprintf (cmd,"more %s", filename2);
		break;

	case SOURCE:
		sprintf (cmd,"more %s",	filename);
		break;

	case MAN:
		sprintf (cmd,"\
			%s/cmd MAN '%s' '%s' '%s' < %s |\
			nroff -man | ul -t%s | more -f -s",

			SM_EXEC, srclib_name + SRCLIB_OFFSET, last_change, version_nr, filename3,
			getenv ("TERM"));
		break;			

	case TEX:
		printf ("\n DISPLAY=%s\n\n", getenv ("DISPLAY"));
		sprintf (cmd,"\
			%s/cmd TEX < %s '%s' '%s' '%s' > %s; \
			cat %s/texdoc1.tex %s %s/texdoc2.tex > %s/%s.tex; \
			cd %s; \
			latex %s.tex > /dev/null ; \
			%s %s %s.dvi > /dev/null &",

			SM_EXEC, filename3, srclib_name + SRCLIB_OFFSET, last_change, version_nr, filename2,
			SM_LATEX, filename2, SM_LATEX, SM_TEX_TMP, txt,
			SM_TEX_TMP,
			txt,
			DVI_COMMAND, DVI_OPTIONS, txt);
		break;


	default:
		printf ("\nnot implemented\n");
	}

 system  (cmd);

 return (1);
 }
