
#include "def.h"
#include "macro.h"


#define m_skn_gral(a,b,c,d) ( m_skn_po(a,b,c,d), C_O_K(d,GRAL) )
#define b_skn_gral(a,b,c,d) ( b_skn_po(a,b,c,d), C_O_K(d,GRAL) )

INT konj_perm_perm(perm,konj,erg)    OP perm,konj,erg;
/* AK 070789 V1.0 */ /* AK 200891 V1.3 */
{
#ifdef PERMTRUE
	INT i;

        first_permutation(s_p_l(konj),erg);
	for (i=0L;i<S_P_LI(perm);i++)
	     M_I_I(s_p_ii(konj,s_p_ii(perm,i)-1L),s_p_i(erg,S_P_II(konj,i)-1L));
	return(OK);
#endif
}

INT mult_gral_gral(eins,zwei,ergebnis) OP eins, zwei, ergebnis;
/* AK 100789 V1.0 */ /* MB 311290 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE

	OP  z, ez, zz;


	if (not EMPTYP(ergebnis))
		freeself(ergebnis);
	zz = zwei;
	while (zz != NULL)
	{
		ez = eins;
		while (ez != NULL)
		{
			z = callocobject();
			b_skn_gral(callocobject(),callocobject(),NULL,z);
			mult(  S_PO_S(ez), S_PO_S(zz), S_PO_S(z) );
			mult(	S_PO_K(ez), S_PO_K(zz), S_PO_K(z) );
		        insert(z,ergebnis,NULL,NULL);
			ez = S_PO_N(ez);
		};
		zz = S_PO_N(zz);
	};
	return(OK);
#else
	error("mult_gral_gral: object not available");
	return(ERROR);
#endif
}


INT horizontal_sum(n,a)      OP n,a; 
/* MB 311290 */ /* AK 200691 V1.2 */ /* AK 200891 V1.3 */
{

	OP p,q;

        p= callocobject();
	if (not EMPTYP(a))
		freeself(a);
	first_permutation(n,p);
	do {
		q= callocobject();
		m_skn_gral(p,cons_eins,NULL,q);
		insert(q,a,NULL,NULL);
    
	   } while(next(p,p));
	freeall(p);
	return OK;
}




INT vertikal_sum(n,a)      OP n,a; 
/* MB 311290 */ /* AK 200691 V1.2 */ /* AK 200891 V1.3 */
{
	OP p,z;
        p= callocobject();
	if (not EMPTYP(a))
		freeself(a);
	first_permutation(n,p);
        do     {
		z = callocobject();
		 m_skn_gral(p,callocobject(),NULL,z);
		 signum(p,S_PO_K(z));
		 insert(z,a,NULL,NULL);
 		} while(next(p,p));
        return OK;
}


#ifdef TABLEAUXTRUE
INT konjugation(gral,tab,i,erg)     OP gral, tab ,erg; INT i; 
/* MB 311290 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE

	OP  p, v, w, x, z, zeiger;
	INT j;

	p = callocobject();
	v = callocobject();
	w = callocobject();
	x = callocobject();
	z = callocobject();

	init(GRAL,erg);

       	weight(tab,w);
	
	
        first_permutation(w,v);
	zeiger = gral;
	while (zeiger != NULL)
	{
          copy(v,p);
          for(j=0L;j<s_p_li(S_PO_S(zeiger));j++)
	          M_I_I(s_t_iji(tab,i,s_p_ii(S_PO_S(zeiger),j)-1L),
                        s_p_i(p,s_t_iji(tab,i,j)-1L));
          m_skn_gral(p,S_PO_K(zeiger),NULL,z);
	  add_apply(z,erg);
	  zeiger = S_PO_N(zeiger);
	};


	freeall(p);
	freeall(x);
	freeall(w);
	freeall(v);
	freeall(z);
	return OK;
#endif
}
#endif /* TABLEAUXTRUE */



#ifdef TABLEAUXTRUE
INT konjugierende(t,i,cp)   OP t,cp; INT i;  
/* MB 311290 */ /* AK 200891 V1.3 */
{

	OP  v,w,x,y,z;
	INT j;

	v = callocobject();
	w = callocobject();
	x = callocobject();
	y = callocobject();
	z = callocobject();
	weight(s_t_u(t),w);
	first_permutation(w,v);
	copy(v,y);
	for(j=0L;j<s_pa_ii(s_t_u(t),s_t_hi(t)-1-i);j++)
		{
		 copy(v,x);
		 c_i_i(s_p_i(x,j),s_t_iji(t,i,j));
		 c_i_i(s_p_i(x,s_t_iji(t,i,j)-1L),j+1L);
		 mult(y,x,z);
		 copy(z,y);
		}
	copy(y,cp);
	freeall(z);
	freeall(w);
	freeall(v);
	freeall(y);
	freeall(x);
}
#endif /* TABLEAUXTRUE */
	

INT konj_gral_perm(gral,perm,ergebnis) OP gral, perm, ergebnis;
/* AK 100789 V1.0 */ /* MB 311290 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE

	OP  x, z, zeiger;

	x = callocobject();
	z = callocobject();

	if (not EMPTYP(ergebnis))
		freeself(ergebnis);
	zeiger = gral;
	while (zeiger != NULL)
	{
        	konj_perm_perm( S_PO_S(zeiger), perm, x );
        	m_skn_gral(x,S_PO_K(zeiger),NULL,z);
		add_apply(z,ergebnis);
		zeiger = S_PO_N(zeiger);
	};
	freeall(x);
	freeall(z);
	return(OK);
#else
	error("konj_gral_perm: POLYNOM not available");
	return(ERROR);
#endif
}


#ifdef TABLEAUXTRUE
INT hplus(tab,h)   OP tab, h; 
/* MB 311290 */ /* AK 200691 V1.2 */ /* AK 200891 V1.3 */
{
	OP  u,w,x,y,z;
	INT i;

	u = callocobject();
	w = callocobject();
	x = callocobject();
	y = callocobject();
	z = callocobject();
	if (not EMPTYP(h)) 
		freeself(h);
	weight(tab,w);
	first_permutation(w,u);
	m_skn_gral(u,cons_eins,NULL,x);
	for(i=0L;i<s_t_hi(tab);i++)
		{
		if(s_pa_ii(s_t_u(tab),s_t_hi(tab)-1-i)>1L)
			{
			 horizontal_sum(s_pa_i(s_t_u(tab),s_t_hi(tab)-1L-i),y);
			 konjugation(y,tab,i,z);
			 mult_gral_gral(x,z,y); 
			 copy(y,x);
			}
		}
	copy(x,h);
	freeall(u);
	freeall(w);
	freeall(x);
	freeall(y);
	freeall(z);
}
#endif /* TABLEAUXTRUE */


#ifdef TABLEAUXTRUE
INT vminus(tab,v)   OP tab,v; 
/* MB 311290 */ /* AK 200891 V1.3 */
{
	OP u,w,x,y,z,m,tc;
	INT i;

	m = callocobject();
	tc = callocobject();
	u = callocobject();
	w = callocobject();
	x = callocobject();
	y = callocobject();
	z = callocobject();
	transpose(s_t_s(tab),m);
	m_matrix_tableaux(m,tc);
	weight(tc,w);
	first_permutation(w,u);
	m_skn_gral(u,cons_eins,NULL,x);
	/*
	copy(embed(u),x);
	*/
	for(i=0L;i<s_t_hi(tc);i++)
		{
		if(s_pa_ii(s_t_u(tc),s_t_hi(tc)-1-i)>1L)
			{
			 if (not EMPTYP(y))
				freeself(y);
			 vertikal_sum(s_pa_i(s_t_u(tc),s_t_hi(tc)-1-i),y);
			 konjugation(y,tc,i,z);
			 mult_gral_gral(x,z,y); 
			 freeself(x);
			 copy(y,x);
			}
		}
	copy(x,v);
	freeall(z);
}
#endif /* TABLEAUXTRUE */

#ifdef TABLEAUXTRUE
INT idempotent(tab,idp)  OP tab,idp;
/* MB 311290 */ /* AK 200891 V1.3 */
{
	 OP  hz,h,v,x;

	 hz = callocobject();
	 h = callocobject();
	 v = callocobject();
	 x = callocobject();
	 hplus(tab,h);
	 vminus(tab,v);
	 mult_gral_gral(h,v,x);
	 dimension(s_t_u(tab),hz);
	 invers(hz,hz);
	 mult(hz,x,v);
	 copy(v,idp);
	 freeall(x);
	return OK;
}
#endif /* TABLEAUXTRUE */

#ifdef CHARTRUE
INT zentralprim(part,idp)  OP part,idp;
 /* MB 311290 */ /* AK 200891 V1.3 */
{
	 OP  hz,p,v,w,x,y,zt,vecsc;
	 INT ind;

	 hz = callocobject();
	 p = callocobject();
	 v = callocobject();
	 w = callocobject();
	 x = callocobject();
	 y = callocobject();
	 zt = callocobject();
	 vecsc = callocobject();
	 m_part_sc(part,vecsc);
	 weight(part,w);
	 first_permutation(w,p);
	 do {
		zykeltyp(p,zt);
		ind = indexofpart(zt);
		if(S_I_I(S_V_I(s_sc_w(vecsc),ind)))
			{
			 m_skn_gral(p,S_V_I(s_sc_w(vecsc),ind),
				   NULL, x);
			 add_apply(x,y);
			}
		}  while(next(p,p));
	 dimension(part,hz);
	 invers(hz,hz);
	 mult(hz,y,v);
	 copy(v,idp);
	 freeall(vecsc);freeall(v);freeall(hz);freeall(y);
	freeall(zt); freeall(x);freeall(p); freeall(w);
	return OK;
}
#endif /* CHARTRUE */


INT konjugation2(gral,perm,ergebnis)     OP gral, perm, ergebnis; 
/* MB 311290 */ /* AK 200891 V1.3 */
{
#ifdef POLYTRUE
	OP  p, v,  x, z, zeiger;
	INT j;

	p = callocobject();
	v = callocobject();
	x = callocobject();
	z = callocobject();

        first_permutation(s_p_l(perm),v);
	zeiger = gral;
	while (zeiger != NULL)
	{
          copy(v,p);
          for(j=0L;j<S_P_LI(S_PO_S(zeiger));j++)
	          M_I_I(S_P_II(perm,s_p_ii(S_PO_S(zeiger),j)-1L),
                        s_p_i(p,S_P_II(perm,j)-1L));
          m_skn_gral(p,S_PO_K(zeiger),NULL,z);
	  add(z,x,x);
	  zeiger = S_PO_N(zeiger);
	};
	copy(x,ergebnis);
	return OK;
#endif
}

INT objectread_gral(filename,gral)  FILE *filename;OP gral; 
/* MB 311290 */ /* AK 200891 V1.3 */
{
	char antwort[2];

	b_sn_l(callocobject(),NULL,gral);

	objectread_monom(filename,S_L_S(gral));
	fscanf(filename,"%s",antwort);
	if (antwort[0]  == 'j')
	{
		C_L_N(gral,callocobject());
		objectread_gral(filename,S_L_N(gral));
	}
	return(OK);
}
 
INT objectwrite_gral(filename,gral)  FILE *filename;OP gral;
/* ausgabe eines list-objects
ausgabe bis einschliesslich next == NULL */ /* MB 311290 */
/* AK 200891 V1.3 */
{

	OP zeiger = gral;

		{
		fprintf(filename, " %d ",POLYNOM);
		
		objectwrite(filename,S_PO_S(zeiger));
		objectwrite(filename,S_PO_K(zeiger));
		zeiger=S_PO_N(zeiger);
		while (zeiger != NULL) /* abbruch bedingung */
		{
			fprintf(filename,"j\n");
			objectwrite(filename,S_PO_S(zeiger));
			objectwrite(filename,S_PO_K(zeiger));
			zeiger=S_PO_N(zeiger);/*zeiger auf das naechste element*/
		}
		fprintf(filename,"n\n");
		}
	return(OK);
}

INT scan_gral(a) OP a;
/* AK 200891 V1.3 */
{
#ifdef POLYTRUE
	char antwort[2];
	INT erg;


	/* ergebnis ist ein leeres object */
	b_sn_l(callocobject(),NULL,a);
	C_O_K(a,GRAL);
	/* self ist nun initialisiert */

	erg=scan(MONOM,S_L_S(a));
	if (erg == ERROR) {
		error("scan_gral:error in scaning listelement");
		return(ERROR); 
		}

	printeingabe("one more monom  j/n");
	scanf("%s",antwort);
	if (antwort[0]  == 'j')
		{
			C_L_N(a,callocobject());
			scan_gral(S_L_N(a));
		};
	return OK;
#endif /* POLYTRUE */
}

INT add_apply_gral_gral(a,b) OP a,b;
/* AK 200891 V1.3 */
	{
	OP c = callocobject();
	copy_list(a,c);
	return(insert(c,b,NULL,NULL));
	}

#ifdef POLYTRUE
INT add_apply_gral(a,b) OP a,b;
/* AK 200691 V1.2 */ /* AK 200891 V1.3 */
{
	if (EMPTYP(b)) 
		return(copy_polynom(a,b));
	switch(S_O_K(b)) {
		case GRAL: 
			return add_apply_gral_gral(a,b);
		default:
			{ 
			/* 210291 */
			OP c = callocobject();
			INT erg;
			*c = *b;
			C_O_K(b,EMPTY);
			erg = add(a,c,b);
			erg += freeall(c);
			return erg;
			}
		}
}
#endif /* POLYTRUE */


INT mult_apply_gral(a,b) OP a,b;
/* AK 200691 V1.2 */
/* AK 200891 V1.3 */
{
	switch (S_O_K(b))
	{
	case GRAL:
		{
		OP c;
		c = callocobject();
		*c = *b;
		C_O_K(b,EMPTY);
		mult_gral_gral(a,c,b);
		freeall(c);
		return OK;
		}
	default:
		return error("mult_apply_gral:wrong second type");
	}
}
