# Copyright Per Bothner 1987. Read the file Q-INFO
#(
Symbolic differentiation:

An expression is either:
 - a number (constant) e.g. 2
 - a symbol (variable) e.g. 'x
 - a three element sequence where the first element is a
   symbol representing an operator ('plus, 'times, etc)
   and the next two elements are expressions.

To differentiate <expression> over <variable> do:
<expression> D <variable>
#)

D: $e;x$ (
## Uncomment this to get a trace-out:
## stdout << "( " << e << ") D (" << x << " )\n";

 TEST e
  IF ['plus a b] : [plus (a D x) (b D x)]
  IF ['times a b] : ['plus ['times a (b D x)] ['times (a D x) b]]
  IF x : 1
  IF : 0
  END TEST
)

## <expression> Simp <variable> <value>
## Simplify <expression> by substituting <value> for <variable>
## Some algebraic transformations are also done.
## I.e. "e Simp () 0" does a decent job of cleaning up "e".
Simp: $e;var;val$ (
    TEST e
      IF var : val
      IF 'plus, a, b, :
        TEST a Simp var val; b Simp var val
          IF x~FixInt;y~FixInt : x + y
          IF x~Float;y~Float : x + y
          IF x; 0 : x
          IF 0; y : y
          IF x;y : 'plus, x, y,
        END TEST
      IF 'times, a, b, :
        TEST a Simp var val; b Simp var val
          IF x~FixInt;y~FixInt : x * y
          IF x~Float;y~Float : x * y
          IF _; 0 : 0
          IF 0; _ : 0
          IF x; 1 : x
          IF 1; y : y
          IF x;y : 'times, x, y,
        END TEST
      IF : e
  END TEST
)

## print expression 'e' on file 'file'
PrintExpr: $file;e$  (
    TEST e
      IF 'plus, a, b, :
        file << "("
	file PrintExpr a
        file << ") + ("
        file PrintExpr b
        file << ")"
      IF 'times, a, b, :
        file << "("
        file PrintExpr a
        file << ") * ("
        file PrintExpr b
        file << ")"
      IF : file << e
)
