#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>

#include "BigZ.h"
#include "BntoBnn.h"


#define NEWLINE		fprintf(stderr,"\n")
#define From(A)		BzToBigNum(BzFromString(A,10), &foonl)
#define To(A)		BzToString(BzFromBigNum(A,l),10)


double runtime() {
	struct rusage r;
	struct timeval t;

	getrusage(0, &r);
	t = r.ru_utime;
	return(1000*t.tv_sec + (t.tv_usec/1000.));
}

/* used for conversion BigZ --> BigNum */
static unsigned     foonl;

main()
{
   printf("Times on a SUN 3/60 (3.4) \n");
   printf("\n");
   printf("Le_Lisp 15.21 : 3.4s \n");
   printf("C             : 2.7s \n");
   BnBench();
}

BnBench() {
	double t1, tp = 0.0;
	int i;

	BigNum a = From("6290843252034247832488948530889507820372534220155749337406213413141456028021015613339401109972769059704411603077661248901138314618192385808292059038302087");
	BigNum e = From("7301528981815353440186284264567853991785844716335520074738049695514504674875031196492510938054180065876409690571413838538140398885731057226412015631919490");
        BigNum n = From("8147771155789330029278033691977920011607194547896681542175548825699070281758159013667940742879342370258220466020565804322942452235743797417874170775049979");
       /* r = a**e mod n */
	BigNum r = From("6592812686517455533682192402687982584732723980364904769602645412889636956320139746048674348010313976797086419629753160088338140528581529611487558287516924");

	int l = 16*32/BN_DIGIT_SIZE;
	BigNum p = BnCreate((BigNumType)1, l);
	for(i=0; i<5; i++) {
		t1 = runtime();
		BnExpMod(p, a, l, e, l, n, l);
		tp += runtime() - t1;
		if(BnCompare(p,0,l,r,0,l) != BN_EQ)
		  printf("Error: the result should be %s and not %s\n",To(r),To(p));
	}
	printf("Time is %f\n", tp/5000);
}
	
/* Modular exponentiation */
/* p[0..nl-1] <- a[0..al-1]**e[0..el-1] mod n[0..nl-1] */
BnExpMod(p, a, al, e, el, n, nl)
	BigNum p, a, e, n;
	int al, el;
	register int nl;
	{
	    register int rz = 0;
	    register BigNum c = BnCreate((BigNumType)1, 2);
	    register int tmpl = 1+ (nl<<1);
	    register BigNum tmp = BnCreate((BigNumType)1, tmpl);
	    register int es;
	    register int pl=al;

	    BnAssign(p, rz, a, rz, al);
	 /* el becomes the current address of the most significant digit */
	    BnAssign(c, rz, e, --el, 1);
	    es = 1 + BnNumLeadingZeroBitsInDigit(c, rz);
            BnShiftLeft(c, rz, 1, c, 1, es);
	    es = BN_DIGIT_SIZE - es;
	    while(el >= rz){
	      while (es){
		es--;
	        /* tmp <- p^2 */
	        tmpl = 1 + (pl<<1);
	        BnSetToZero(tmp, rz, tmpl);
		BnMultiply(tmp, rz, tmpl, p, rz, pl, p, rz, pl);
	        /* tmp <- tmp mod n */
		BnDivide(tmp, rz, tmpl, n, rz, nl);
		/* p <- tmp */
		BnAssign(p, rz, tmp, rz, nl);
	        pl = BnNumDigits(p, rz, nl);
                BnShiftLeft(c, rz, 1, c, 1, 1);
                if(BnIsDigitOdd(c, 1)) {
                   /* tmp <- p*a */
		   tmpl = 1 + al + pl;
		   BnSetToZero(tmp, rz, tmpl);
		   BnMultiply(tmp, rz, tmpl, p, rz, pl, a, rz, al);
		   /* tmp <- tmp mod n */
		   BnDivide(tmp, rz, tmpl, n, rz, nl);
		   /* p <- tmp */
		   BnAssign(p, rz, tmp, rz, nl);
		   pl = BnNumDigits(p, rz, nl);
                }
              }
	      if(el--){
  	        BnAssign(c, rz, e, el, 1);
    		es = BN_DIGIT_SIZE;
	      }
	    }
	}
