	.verstamp       1 31
 # Copyright     Digital Equipment Corporation & INRIA     1988, 1989
 #
 #		KerN for Mips
 #		Paul Zimmermann & Robert Ehrlich & Bernard Paul Serpette
 #
	.text	
	.align	2
	.globl	BnnSetToZero
	.ent	BnnSetToZero			# (nn nl)
BnnSetToZero:
		sll	$5,2			# nl <<= 2;
		addu	$5,$4			# nl += nn;
		beq	$4,$5,BSTZ2		# if(nn == nl) goto BSTZ2;
BSTZ1:		sw	$0,($4)			# *nn = 0;
		addu	$4,4			# nn++;
		bne	$4,$5,BSTZ1		# if(nn != nl) goto BSTZ1;
BSTZ2:		j	$31			# return;
	.end	BnnSetToZero

	.align	2
	.globl	BnnAssign
	.ent	BnnAssign			# (mm nn nl)
BnnAssign:
		ble	$4,$5,BAG2		# if(mm <= nn) goto BAG2;
		sll	$12,$6,2		# X = nl << 2;
		addu	$4,$12			# mm += X;
		addu	$5,$12			# nn += X;
		b	BAG4			# goto BAG4;
BAG1:		lw	$12,($5)		# X = *(nn);
		sw	$12,($4)		# *(mm) = X
		addu	$4,4			# mm++;
		addu	$5,4			# nn++;
		subu	$6,1			# nl--;
BAG2:		bnez	$6,BAG1			# if(nl) goto BAG1;
		j	$31			# return;
BAG3:		subu	$4,4			# mm--;
		subu	$5,4			# nn--;
		lw	$12,($5)		# X = *(nn);
		sw	$12,($4)		# *(mm) = X;
		subu	$6,1			# nl--;
BAG4:		bnez	$6,BAG3			# if(nl) goto BAG3;
		j	$31			# return;
	.end	BnAssign

	.align	2
	.globl	BnnSetDigit
	.ent	BnnSetDigit			# (nn d)
BnnSetDigit:
		sw	$5,0($4)		# *nn = d;
		j	$31			# return;
	.end	BnnSetDigit

	.align	2
	.globl	BnnGetDigit
	.ent	BnnGetDigit			# (nn)
BnnGetDigit:
		lw	$2,0($4)		# return(*nn);
		j	$31
	.end	BnnGetDigit

	.align	2
	.globl	BnnNumDigits
	.ent	BnnNumDigits			# (nn nl)
BnnNumDigits:
		sll	$12,$5,2
		addu	$4,$12			# nn = &nn[nl];
		b	BND2			# goto BND2;
BND1:		subu	$5,1			# nl--;
		subu	$4,4			# nn--;
		lw	$12,0($4)		# X = *nn;
		bnez	$12,BND3		# if(X) goto BND3;
BND2:		bnez	$5,BND1			# if(nl) goto BND1;
		li	$2,1			# return(1);
		j	$31
BND3:		addu	$2,$5,1			# return(nl);
		j	$31
	.end	BnnNumDigits

	.align	2
	.globl	BnnNumLeadingZeroBitsInDigit
	.ent	BnnNumLeadingZeroBitsInDigit	# (d)
BnnNumLeadingZeroBitsInDigit:
		li	$14,-2147483648		# mask = 1 << 31;
		move	$2,$0			# p = 0;
		bne	$4,0,BLZ2		# if(!d) goto BLZ2;
		li	$2,32			# return(32);
		j	$31
BLZ1:		addu	$2,1			# p++;
		srl	$14,1			# mask >>= 1;
BLZ2:		and	$15,$4,$14		# X = d & mask;
		beq	$15,0,BLZ1		# if(!X) goto BLZ1;
BLZ3:		j	$31			# return(p);
	.end	BnnNumLeadingZeroBitsInDigit

	.align	2
	.globl	BnnDoesDigitFitInWord
	.ent	BnnDoesDigitFitInWord		# (d)
BnnDoesDigitFitInWord:
		li	$2,1			# return(1);
		j	$31
	.end	BnnDoesDigitFitInWord

	.align	2
	.globl	BnnIsDigitZero
	.ent	BnnIsDigitZero			# (d)
BnnIsDigitZero:
		seq	$2,$4,0			# return(d == 0);
		j	$31
	.end	BnnIsDigitZero

	.align	2
	.globl	BnnIsDigitNormalized
	.ent	BnnIsDigitNormalized		# (d)
BnnIsDigitNormalized:
		and	$2,$4,-2147483648	# return(d & (1 << 31));
		j	$31
	.end	BnnIsDigitNormalized

	.align	2
	.globl	BnnIsDigitOdd
	.ent	BnnIsDigitOdd			# (d)
BnnIsDigitOdd:
		and	$2,$4,1			# return(d & 1);
		j	$31
	.end	BnnIsDigitOdd

	.align	2
	.globl	BnnCompareDigits
	.ent	BnnCompareDigits		# (d1 d2)
BnnCompareDigits:
 # 254	    return (d1 > d2 ? BN_GT : (d1 == d2 ? BN_EQ : BN_LT));
		beq	$4,$5,BCDeq		# if(d1 == d2) goto BCDeq;
		bleu	$4, $5,BCDinf		# if(d1 < d2) goto BCDinf;
		li	$2, 1			# return(1);
		j	$31
BCDeq:		move	$2,$0			# return(0);
		j	$31
BCDinf:		li	$2,-1			# return(-1);
		j	$31
	.end	BnnCompareDigits

	.align	2
	.globl	BnnComplement
	.ent	BnnComplement			# (nn nl)
BnnComplement:
		beq	$5,$0,BCM2		# if(nl == 0) goto BCM2;
BCM1:		subu	$5,1			# nl--;
		lw	$14,0($4)		# X = *nn;
		nor	$14,$0			# X ^= -1;
		sw	$14,0($4)		# *nn = X
		addu	$4,4			# nn++;
		bne	$5,0,BCM1		# if(nl != 0) goto BCM1;
BCM2:		j	$31			# return;
	.end	BnnComplement

	.align	2
	.globl	BnnAndDigits
	.ent	BnnAndDigits			# (nn d)
BnnAndDigits:
		lw	$14,0($4)		# X = *nn;
		and	$14,$5			# X &= d;
		sw	$14,0($4)		# *nn = d;
		j	$31			# return;
	.end	BnnAndDigits

	.align	2
	.globl	BnnOrDigits
	.ent	BnnOrDigits			# (nn d)
BnnOrDigits:
		lw	$14,0($4)		# X = *nn;
		or	$14,$5			# X |= d;
		sw	$14,0($4)		# *nn = X;
		j	$31			# return;
	.end	BnnOrDigits

	.align	2
	.globl	BnnXorDigits
	.ent	BnnXorDigits			# (nn d)
BnnXorDigits:
		lw	$14,0($4)		# X = *nn;
		xor	$14,$5			# X ^= d;
		sw	$14,0($4)		# *nn = X;
		j	$31			# return;
	.end	BnnXorDigits

	.align	2
	.globl	BnnShiftLeft
	.ent	BnnShiftLeft			# (mm ml nbi)
BnnShiftLeft:
		move	$2,$0			# res = 0;
		beq	$6,0,BSL2		# if(nbi == 0) goto BSL2;
		li	$14,32			# rnbi = 32;
		subu	$14,$6			# rnbi -= nbi;
		beq	$5,0,BSL2		# if(ml == 0) goto BSL2;
BSL1:		subu	$5,1			# ml--;
		lw	$25,0($4)		# save = *mm;
		sll	$24,$25,$6		# X = save << nbi;
		or	$24,$2			# X |= res;
		sw	$24,0($4)		# *mm = X;
		addu	$4,4			# mm++;
		srl	$2,$25,$14		# res = save >> rnbi;
		bne	$5,0,BSL1		# if(ml != 0) goto BSL1;
BSL2:		j	$31			# return(res);
	.end	BnnShiftLeft

	.align	2
	.globl	BnnShiftRight
	.ent	BnnShiftRight			# (mm ml nbi)
BnnShiftRight:
		move	$2,$0			# res = 0;
		beq	$6,0,BSR2		# if(nbi == 0) goto BSR2;
		sll	$14,$5,2		# X = ml << 2;
		addu	$4,$14			# mm += X;
		li	$14,32			# lnbi = 32;
		subu	$14,$6			# lnbi -= nbi;
		beq	$5,0,BSR2		# if(ml == 0) goto BSR2
BSR1:		subu	$5,1			# ml--;
		subu	$4,4			# mm--;
		lw	$25,0($4)		# save = *mm;
		srl	$24,$25,$6		# X = save >> nbi;
		or	$24,$2			# X |= res
		sw	$24,0($4)		# *mm = X;
		sll	$2,$25,$14		# res = save << lnbi;
		bne	$5,0,BSR1		# if(ml != 0) goto BSR1;
BSR2:		j	$31			# return(res);
	.end	BnnShiftRight

	.align	2
	.globl	BnnAddCarry
	.ent	BnnAddCarry			# (nn nl car)
BnnAddCarry:
		beq	$6,0,BAC3		# if(car == 0) return(0);
		beq	$5,0,BAC2		# if(nl == 0) return(1);
BAC1:		subu	$5,1			# nl--;
		lw	$9,0($4)		# X = *nn;
		addu	$9,1			# X++;
		sw	$9,0($4)		# *nn = X;
		addu	$4,4			# nn++;
		bne	$9,$0,BAC3		# if(X) goto BAC3;
		bne	$5,$0,BAC1		# if(nl) goto BAC1;
BAC2:		li	$2,1			# return(1);
		j	$31
BAC3:		li	$2,0			# return(0);
		j	$31
	.end	BnnAddCarry

	.align	2
	.globl	BnnAdd
	.ent	BnnAdd				# (mm ml nn nl car)
BnnAdd:
		lw	$14, 16($sp)		# c = carryin;
		subu	$5,$7			# ml -= nl;
		bne	$7,$0,BADD1		# if(nl) goto BADD1;
		bne	$14,$0,BADD7		# if(c) goto BADD7;
BADD0:		move	$2,$0			# return(0)
		j	$31
BADD1:		subu	$7,1			# nl--;
		lw	$15,0($4)		# save = *mm;
		addu	$14,$15			# c += save;
		bgeu	$14,$15,BADD2		# if(c >= save) goto BADD2
		lw	$10,0($6)		# X = *nn;
		sw	$10,0($4)		# *mm = X
		addu	$6,4			# nn++;
		addu	$4,4			# mm++;
		li	$14,1			# c = 1;
		bne	$7,$0,BADD1		# if(nl) goto BADD1;
		b	BADD7
BADD2:		lw	$15,0($6)		# save = *nn;
		addu	$6,4			# nn++;
		addu	$14,$15			# c += save;
		sw	$14,0($4)		# *mm = c;
		addu	$4,4			# mm++;
		bltu	$14,$15,BADD3		# if(c < save) goto BADD3;
		move	$14,$0			# c = 0;
		bne	$7,$0,BADD1		# if(nl) goto BADD1;
		move	$2,$0			# return(0)
		j	$31
BADD3:		li	$14,1			# c = 1;
		bne	$7,$0,BADD1		# if(nl) goto BADD1;
BADD7:		beq	$5,0,BADD9		# if(ml == 0) return(1);
BADD8:		subu	$5,1			# ml--;
		lw	$9,0($4)		# X = *mm;
		addu	$9,1			# X++;
		sw	$9,0($4)		# *mm = X;
		addu	$4,4			# mm++;
		bne	$9,$0,BADD0		# if(X) return(0);
		bne	$5,$0,BADD8		# if(ml) goto BADD8;
BADD9:		li	$2,1			# return(1);
		j	$31
	.end	BnnAdd

	.align	2
	.globl	BnnSubtractBorrow
	.ent	BnnSubtractBorrow		# (nn nl car)
BnnSubtractBorrow:
		bne	$6,0,BSB3		# if(car) return(1);
		beq	$5,0,BSB2		# if(nl == 0) return(0);
BSB1:		subu	$5,1			# nl--;
		lw	$9,0($4)		# X = *nn;
		move	$10,$9			# Y = X;
		subu	$9,1			# X--;
		sw	$9,0($4)		# *nn = X;
		addu	$4,4			# nn++;
		bne	$10,$0,BSB3		# if(Y) return(1);
		bne	$5,$0,BSB1		# if(nl) goto BSB1;
BSB2:		li	$2,0			# return(0);
		j	$31
BSB3:		li	$2,1			# return(1);
		j	$31
	.end	BnnSubtractBorrow

	.align	2
	.globl	BnnSubtract
	.ent	BnnSubtract 2			# (mm ml nn nl car)
BnnSubtract:
		lw	$14, 16($sp)		# c = car;
		subu	$5,$7			# ml -= nl;
		bne	$7,$0,BS1		# if(nl) goto BS1;
		beq	$14,$0,BS7		# if(!c) goto BS7;
BS0:		li	$2,1			# return(1)
		j	$31
BS1:		subu	$7,1			# nl--;
		lw	$15,0($4)		# save = *mm;
		lw	$12,0($6)		# invn = *nn;
		addu	$6,4			# nn++;
		nor	$12,$0			# invn ^= -1;
		addu	$14,$15			# c += save;
		bgeu	$14,$15,BS2		# if(c >= save) goto BS2
		sw	$12,0($4)		# *mm = invn
		addu	$4,4			# mm++;
		li	$14,1			# c = 1;
		bne	$7,$0,BS1		# if(nl) goto BS1;
		li	$2,1			# return(1)
		j	$31
BS2:		addu	$14,$12			# c += invn;
		sw	$14,0($4)		# *mm = c;
		addu	$4,4			# mm++;
		bgeu	$14,$12,BS3		# if(c >= invn) goto BS3;
		li	$14,1			# c = 1;
		bne	$7,$0,BS1		# if(nl) goto BS1;
		li	$2,1			# return(1)
		j	$31
BS3:		move	$14,$0			# c = 0;
		bne	$7,$0,BS1		# if(nl) goto BS1;
BS7:		beq	$5,0,BS9		# if(ml == 0) return(0);
BS8:		subu	$5,1			# ml--;
		lw	$9,0($4)		# X = *mm;
		move	$10,$9			# Y = X
		subu	$9,1			# X--;
		sw	$9,0($4)		# *mm = X;
		addu	$4,4			# mm++;
		bne	$10,$0,BS0		# if(X) return(1);
		bne	$5,$0,BS8		# if(ml) goto BS8;
BS9:		move	$2,$0			# return(0);
		j	$31
	.end	BnnSubtract

	.align	2
	.globl	BnnMultiplyDigit
	.ent	BnnMultiplyDigit		# (pp pl mm ml d)
BnnMultiplyDigit:
		lw	$8, 16($sp)		# d;
		beq	$8,0,BMD7		# if(d == 0) return(0);
		bne	$8,1,BMD2		# if(d != 1) goto BMD2;
		sw	$0, 16($sp)
		b	BnnAdd			# BnnAdd(pp, pl, mm, ml, 0);
BMD2:		subu	$5,$7			# pl -= ml;
		move	$9,$0			# low = 0;
		beq	$7,0,BMD6		# if(!ml) goto BMD6;
BMD3:		subu	$7,1			# ml--;
		lw	$13,0($6)		# X = *mm;
		addu	$6,4			# mm++;
		lw	$15,0($4)		# save = *pp;
		addu	$14,$15,$9		# inc = save + low;
		multu	$13,$8			# HI-LO = X * d;
		mfhi	$9			# low = HI;
		bgeu	$14,$15,BMD4		# if(inc >= save) goto BMD4;
		addu	$9,1			# low++;
BMD4:		mflo	$13			# save = LO;
		addu	$14,$13			# inc += save;
		sw	$14,0($4)		# *pp = inc;
		addu	$4,4			# pp++;
		bgeu	$14,$13,BMD5		# if(inc >= save) goto BMD5;
		addu	$9,1			# low++;
BMD5:		bne	$7,0,BMD3		# if(ml) goto BMD3;
BMD6:		lw	$15,($4)		# save = *pp;
		addu	$9,$15			# low += save;
		sw	$9,0($4)		# *pp = low;
		addu	$4,4			# pp++;
		bltu	$9,$15,BMD8		# if(low < save) goto BMD8;
BMD7:		move	$2, $0			# return(0);
		j	$31
BMD8:		subu	$5,1			# pl--;
		beq	$5,0,BMD10		# if(ml == 0) return(1);
BMD9:		subu	$5,1			# pl--;
		lw	$9,0($4)		# X = *pp;
		addu	$9,1			# X++;
		sw	$9,0($4)		# *pp = X;
		addu	$4,4			# pp++;
		bne	$9,$0,BMD7		# if(X) return(0);
		bne	$5,$0,BMD9		# if(pl) goto BMD9;
BMD10:		li	$2,1			# return(1);
		j	$31
	.end	BnnMultiplyDigit

	.align	2
	.globl	BnnDivideDigit
	.ent	BnnDivideDigit			# (qq nn nl d)
BnnDivideDigit:
		move	$11,$31
		move	$10,$4
		move	$9,$5
		move	$8,$6
		move	$4,$7		# k = BnnNumLeadingZeroBitsInDigit(d);
		jal	BnnNumLeadingZeroBitsInDigit
		move	$6,$2
		beq	$6,$0,BDD1		# if(k == 0) goto BDD1;
		move	$4,$9
		move	$5,$8
		jal	BnnShiftLeft		# BnnShiftLeft(nn, nl, k);
		move	$5,$8			# orig_nl = nl;
		sll	$7,$6			# d <<= k;
BDD1:		sll	$3,$8,2
		addu	$9,$3			# nn = &nn[nl];
		subu	$8,1			# nl--;
		subu	$3,4
		addu	$10,$3			# qq = &qq[nl];
		srl	$25,$7,16		# ch = HIGH(d);
		and	$2,$7,65535		# cl = LOW(d);
		subu	$9,4			# nn--;
		lw	$13,0($9)		# rl = *nn;
		beq	$8,0,BDDx		# if(nl == 0) goto BDDx;
BDD2:		subu	$8,1			# nl--;
		move	$12,$13			# rh = rl;
		subu	$9,4			# nn--;
		lw	$13,0($9)		# rl = *nn;
		divu	$14,$12,$25		# qa = rh/ch;
		multu	$2,$14			# HI-LO = cl * qa;
		mflo	$24			# pl = LO;
		multu	$25,$14			# HI-LO = ch * qa;
		mflo	$15			# ph = LO;
		srl	$3,$24,16		# X = HIGH(pl);
		addu	$15,$3			# ph += X;
		sll	$24,16			# pl = L2H(pl);
		bgtu	$15,$12,BDD84		# if(ph > rh) goto BDD84;
		bne	$15,$12,BDD88		# if(ph != rh) goto BDD88;
		bleu	$24,$13,BDD88		# if(pl <= rl) goto BDD88;
BDD84:		sll	$3,$2,16		# X = L2H(cl);
BDD85:		subu	$14,1			# qa--;
		bleu	$3,$24,BDD86		# if(X <= pl) goto BDD86;
		subu	$15,1			# ph--;
BDD86:		subu	$24,$3			# pl -= X;
		subu	$15,$25			# ph -= ch;
		bgtu	$15,$12,BDD85		# if(ph > rh) goto BDD85;
		bne	$15,$12,BDD88		# if(ph != rh) goto BDD88;
		bgtu	$24,$13,BDD85		# if(pl > rl) goto BDD85;
BDD88:		bleu	$24,$13,BDD89		# if(pl <= rl) goto BDD89;
		subu	$12,1			# rh--;
BDD89:		subu	$13,$24			# rl -= pl;
		subu	$12,$15			# rh -= ph;
		subu	$10,4			# qq--;
		sll	$3,$14,16		# X = L2H(qa);
		sw	$3,0($10)		# *qq = X;
		sll	$3,$12,16		# X = L2H(rh);
		srl	$14,$13,16		# qa = HIGH(rl);
		or	$14,$3			# qa |= X;
		divu	$14,$14,$25		# qa /= ch;
		multu	$2,$14			# HI-LO = cl * qa;
		mflo	$24			# pl = LO;
		multu	$25,$14			# HI-LO = ch * qa;
		mflo	$15			# ph = LO;
		srl	$3,$24,16		# X = HIGH(pl);
		addu	$15,$3			# ph += X;
		and	$24,65535		# pl = LOW(pl);
		and	$3,$15,65535		# X = LOW(ph);
		sll	$3,16			# X = L2H(X)
		or	$24,$3			# pl |= X;
		srl	$15,16			# ph = HIGH(ph);
		bgtu	$15,$12,BDD41		# if(ph > rh) goto BDD841;
		bne	$15,$12,BDD44		# if(ph != rh) goto BDD44;
		bleu	$24,$13,BDD44		# if(pl <= rl) goto BDD44;
BDD41:		subu	$14,1			# qa--;
		bleu	$7,$24,BDD42		# if(d <= pl) goto BDD42;
		subu	$15,1			# ph--;
BDD42:		subu	$24,$7			# pl -= d;
		bgtu	$15,$12,BDD41		# if(ph > rh) goto BDD841;
		bne	$15,$12,BDD44		# if(ph == rh) goto BDD44;
		bgtu	$24,$13,BDD41		# if(pl > rl) goto BDD41;
BDD44:		subu	$13,$24			# rl -= pl;
		lw	$3,0($10)		# X = *qq;
		or	$3,$14			# X |= qa
		sw	$3,0($10)		# *qq = X;
		bne	$8,0,BDD2
BDDx:		beq	$6,0,BDD46		# if(k = 0) goto BDD46;
		addu	$3,$9,4			# X = nn + 1;
		beq	$3,$10,BDD46		# if(X == qq) goto BDD46;
		move	$4,$9		# BnnShiftRight(nn, orig_nl, k);
		jal	BnnShiftRight
BDD46:		srl	$2,$13,$6		# return(rl >> k);
		j	$11
	.end	BnnDivideDigit

