# include <stdio.h>
# include "runtime.h"
# include <signal.h>

/* Call the mark routines (tl_mark for a single pointer, mark_all */
/* on groups of pointers) on every top level accessible pointer.  */
/* This is the Russell specific version.                          */

mark_roots()
{
    int * dummy = 0;
    long sp_approx = 0;

    /*
     * mark from registers - i.e., call tl_mark(i) for each
     * register i
     */
	mark_regs(ALIGNMENT); /* usually defined in machine_dep.c */

  /* mark everything on the stack */
    sp_approx = ((long)(&dummy));
#   ifdef DEBUG
	fprintf(stderr, "marking everything from %x to %x\n",
		sp_approx, (startup_sfp == ((char *)0)? stacktop : startup_sfp));
#   endif
    if (startup_sfp == ((char *)0)) {
	mark_all( sp_approx, stacktop, ALIGNMENT);
    } else {
	mark_all( sp_approx, startup_sfp, 4);
	/* Started in Russell; assume Russell conventions are obeyed */
    }

    if (startup_sfp == ((char *)0)) {
      /* We started in non-Russell code.                  */
      /* Mark everything in data and bss segments.        */
      /* Skip gc structures.                              */
	{
	    extern char etext, end;

	    mark_all(DATASTART, begin_gc_arrays, ALIGNMENT);
	    mark_all(end_gc_arrays, &end, ALIGNMENT);
	}
    } else {
      /* Just mark continuations associated with signals      */
      /* There are no Russell roots in data and bss segments  */
	extern struct obj * sig_cont[NSIG];
	mark_all((word *) &(sig_cont[0]), (word *) &(sig_cont[NSIG]), 4);
    }
}

/* Top level mark routine. Mark from the object pointed to by p.       */
/* This is defined here, since alignment is not an explicit parameter. */
/* Thus the routine is language specific.                              */
/* Tl_mark is normally called by mark_regs, and thus must be defined.  */
void tl_mark(p)
word * p;
{
    word * q;

    q = p;
    if (startup_sfp == ((char *)0)) {
      mark_all(&q, (&q)+1, ALIGNMENT);
    } else {
      mark_all(&q, (&q)+1, 4);
    }
}

/* Interface to mark_all that does not require alignment parameter.  */
/* Defined here to keep mach_dep.c programming language independent. */
void tl_mark_all(b,t)
word *b, *t;
{
    if (startup_sfp == ((char *)0)) {
      mark_all(b, t, ALIGNMENT);
    } else {
      mark_all(b, t, 4);
    }
}
