#include <stdio.h>
#include <signal.h>
#include "runtime.h"
#include "types.h"
#include "callcc.h"

extern char ** g_argv;

extern long trace_flag;

/* argv: func[i: val Short] val ChStr (returns ith element of argv) */

MkIP(Argv(i))
struct obj *i;    /* val Short */
{
    return((struct obj *)(g_argv[(int) i]));
}

MkFVAL1(Argv);


/* r_abort: func[] val Void */

MkIP(r_abort())
{
    fprintf(stderr, "User requested abort\n");
    print_tr_stack();
    abort();
}

MkFVAL0(r_abort);


/* put_any:  Print any object */
MkIP(put_any(x))
struct obj * x;
{
    printf("0x%X", x);
}

MkFVAL1(put_any);


/* Eof: func[var Void] val Boolean  */
MkIP(Eof(v))
struct obj *v;   /* var Void */
{
    return((struct obj *)(feof(stdin) != 0));
}

MkFVAL1(Eof);

/* Turn expand_hp (defined in gc/alloc.c) into Russell callable function */
extern struct obj * expand_hp();
MkFVAL1(expand_hp);

# ifdef MERGE_SIZES
#   if MAXOBJSZ == MAXAOBJSZ
#       define MAXSZ MAXOBJSZ
#   else
	--> causes problems here, since we cant map any size to a
	    size that doesnt have a free list.  Either initialization
	    needs to be cleverer, or we need separate maps for atomic
	    and composite objects.
#   endif
    long size_map[MAXSZ+1];

    /* Set things up so that size_map[i] >= i, but not too much bigger */
    /* and so that size_map contains relatively few distinct entries   */
    void init_size_map()
    {
	register int i;
	register int i_rounded_up = 0;

	for (i = 1; i < 8; i++) {
#           ifdef ALIGN_DOUBLE
	      size_map[i] = (i + 1) & (~1);
#           else
	      size_map[i] = i;
#           endif
	}
	for (i = 8; i <= MAXSZ; i++) {
	    if (i_rounded_up < i) {
#               ifdef ALIGN_DOUBLE
		  i_rounded_up = (i + (i >> 1) + 1) & (~1);
#               else                                       
		  i_rounded_up = i + (i >> 1);             
#               endif
		if (i_rounded_up > MAXSZ) {
		    i_rounded_up = MAXSZ;
		}
	    }
	    size_map[i] = i_rounded_up;
	}
    }
# endif

/* Replacement versions of C storage allocation routines   */
/* These should prevent the garbage collector from getting */
/* too confused by C routines.                             */
/* ralloc is a relatively inefficient way to allocate from */
/* Russell routines.                                       */

int dont_gc = 0;  /* don't run garbage collector */

struct obj * ralloc();

struct obj * gc_malloc(size)
int size;
{
    struct obj * result;
    register int lw;

    lw = (size + (sizeof (word)) -1) / (sizeof (word));
    result = ralloc_comp(lw);
    return(result);
}

struct obj * gc_malloc_atomic(size)
int size;
{
    struct obj * result;
    register int lw;

    lw = (size + (sizeof (word)) -1) / (sizeof (word));
    result = ralloc(lw);
    return(result);
}

/* We dont need to distinguish between _allocobj and allocobj here */
/* Since we are dealing only with C code.                          */
# if !defined(VAX) && !defined(M68K_SUN) && !defined(M68K_HP)&& !defined(SPARC) && !defined(I386) && !defined(NS32K) && !defined(MIPS)
  struct obj * allocobj(lw)
  int lw;
  {
    return(_allocobj(lw));
  }

  struct obj * allocaobj(lw)
  int lw;
  {
    return(_allocaobj(lw));
  }
# endif

/* allocate lw words of atomic data */
struct obj * ralloc(lw)
int lw;
{
register struct obj *op;
register struct obj **opp;

    if( lw <= MAXAOBJSZ ) {
	opp = &(aobjfreelist[lw]);
        if( (op = *opp) == ((struct obj *)0) ) {
	    op = _allocaobj(lw);
        }
#       ifdef DEBUG
	    if (((unsigned)(op -> obj_link)) > HEAPLIM
		|| ((unsigned)(op -> obj_link)) < 0x1000
		   && ((unsigned)(op -> obj_link)) != 0  ) {
		abort("bad free list");
            }
#       endif
        *opp = op->obj_link;
        op->obj_link = (struct obj *)0;
    } else {
	register struct hblk * h;

	if (!sufficient_hb(-lw) && !dont_gc) {
	    gcollect();
	}
	h = allochblk(-lw);
	add_hblklist(h);
	op = (struct obj *) (h -> hb_body);
    }
    return(op);
}

/* allocate lw words of composite data */
struct obj * ralloc_comp(lw)
int lw;
{
register struct obj *op;
register struct obj **opp;

    if( lw <= MAXOBJSZ ) {
	opp = &(objfreelist[lw]);
        if( (op = *opp) == ((struct obj *)0) ) {
	    op = _allocobj(lw);
        }
#       ifdef DEBUG
	    if (((unsigned)(op -> obj_link)) > HEAPLIM) {
                abort(3);
            }
#       endif
        *opp = op->obj_link;
        op->obj_link = (struct obj *)0;
    } else {
	register struct hblk * h;

	if (!sufficient_hb(lw) && !dont_gc) {
	    gcollect();
	}
	h = allochblk(lw);
	add_hblklist(h);
	op = (struct obj *) (h -> hb_body);
    }
    return(op);
}

extern long mem_found;

/* General version of the free routine.  On M68K assumes arg is a heap ptr */
_rfree(p)
struct obj *p;
{
    register struct hblk *h;
    register int sz;
    register word * i;
    register word * limit;

#   ifndef M68K
      if (((long)(p)) < ((long)(&end))
	|| ((long)(p)) >= ((long)(heaplim))) {
	return; /* Not a heap object */
      }
#   else
      /* A variant of this check is performed in the grubby a.l. hack below */
#   endif

    h = HBLKPTR(p);
    sz = h -> hb_sz;
    if (sz < 0) {
	sz = -sz;
	if (sz > MAXAOBJSZ) {
	    h -> hb_uninit = 1;
	    del_hblklist(h);
	    freehblk(h);
	} else {
	    p -> obj_link = aobjfreelist[sz];
	    aobjfreelist[sz] = p;
	}
    } else {
	/* Clear the object, other than link field */
	    limit = &(p -> obj_component[sz]);
	    for (i = &(p -> obj_component[1]); i < limit; i++) {
		*i = 0;
	    }
	if (sz > MAXOBJSZ) {
	    p -> obj_link = 0;
	    h -> hb_uninit = 0;
	    del_hblklist(h);
	    freehblk(h);
	} else {
	    p -> obj_link = objfreelist[sz];
	    objfreelist[sz] = p;
	}
    }
    /* Add it to mem_found to prevent anomalous heap expansion */
    /* in the event of repeated explicit frees of objects of   */
    /* varying sizes.                                          */
	mem_found += sz;
}

# ifdef M68K
/* Here we have a version that is hand optimized for the most common path: */

/* First a specialized C version for composite objects  */
/* We assume that size is in d1 at entry                */
rfree_composite(p)
register struct obj *p;
{
    register int sz;            /* Must be d7 */
    register word * i;
    register struct hblk *h;
    register long limit;  /* Actually word * */

    /* sz := correct value */
	asm("movl d1,d7");
    /* Clear the object, other than link field */
	limit = (long)(&(p -> obj_component[sz]));
	for (i = &(p -> obj_component[1]); i < (word *)limit; i++) {
	    *i = 0;
	}
    if (sz > MAXOBJSZ) {
	h = HBLKPTR(p);
	p -> obj_link = 0;
	h -> hb_uninit = 0;
	del_hblklist(h);
	freehblk(h);
    } else {
	p -> obj_link = objfreelist[sz];
	objfreelist[sz] = p;
    }
    /* Add it to mem_found to prevent anomalous heap expansion */
    /* in the event of repeated explicit frees of objects of   */
    /* varying sizes.                                          */
        mem_found += sz;
}

/* And now the really grubby stuff */
    asm(".globl _rfree");
    asm("_rfree:");
    asm("movl sp@(4),d0");          /* a1 := arg; d0 := HBLKPTR(arg) */
    asm("cmpl #_end,d0");           /* Not in data segment ...       */
    asm("blt  rfree_end");
    asm("cmpl #0x0e000000,d0");     /* Not in stack ... */
    asm("bge rfree_end");
    asm("movl d0,a1");
    asm("andl #0xfffff000,d0");
    asm("movl d0,a0");
    asm("movl a0@,d1");             /* d1 := sz */
    asm("jgt  _rfree_composite");   /* call gc_free_composite if sz > 0 */
    asm("cmpl #-512,d1");
    asm("jlt  __rfree");            /* call gc_free for large object */
    asm("negl d1");
    asm("lea _aobjfreelist,a0");    /* a0 := &aobjfreelist[sz] */
    asm("lea a0@(0,d1:l:4),a0");
    asm("movl a0@,a1@");             /* arg -> obj_link := aobjfreelist[sz] */
    asm("movl a1,a0@");              /* aobjfreelist[sz] := 0; */
    asm("addl d1,_mem_found");
    asm("rfree_end:");
    asm("rts");
# else
    rfree(p)
    struct obj * p;
    { _rfree(p); }
# endif

# ifdef M68K
    asm("_gc_free = _rfree");
# else
    gc_free(p)
    struct obj * p;
    { _rfree(p); }
# endif

# ifdef UNDEFINED
char * calloc(i,j)
int i,j;
{
    register struct obj * p;
    register int k;

    k = i * j;
    p = malloc(k);
    for (k--; k >= 0; k--) {
	p -> obj_component[k] = 0;
    }
    return(p);
}

# endif


# ifdef RT
/*
 * these two functions are called only when quick-compiling was used
 * on the input.  They do the allocation for heap objects
 */
struct obj * compalloc(size)
    int size;
{
    static struct obj **opp, *ptr;

    opp = &(objfreelist[size]);
    if (*opp == (struct obj *)0) allocobj(size);
    ptr = *opp;
    *opp = (struct obj *) *ptr;	/* *opp = ptr->next */
    return(ptr);
}


struct obj * atomalloc(size)
    int size;
{
    static struct obj **opp, *ptr;

    opp = &(objfreelist[size]);
    if (*opp == (struct obj *)0) allocobj(size);
    ptr = *opp;
    *opp = (struct obj *) *ptr;	/* *opp = ptr->next */
    return(ptr);
}
# endif

cond_error()
{
    fprintf(stderr, "No applicable guard\n");
    print_tr_stack();
    abort();
}

forward_error()
{
    fprintf(stderr, "Illegal forward reference\n");
    print_tr_stack();
    abort();
}

/* Signal handlers */

void segv_handler()
{
    fprintf(stderr, "Segmentation violation (uninitialized variable?)\n");
    print_tr_stack();
    abort();
}

void intr_handler()
{
    char c;

    fflush(stdout);

    for (;;) {
        fprintf(stderr,
                "\ns for stack trace, c to continue, t to toggle tracing,\n");
        fprintf(stderr, "anything else to quit -");
        do {
            c = getchar();
        } while (c == '\n' || c =='\r');
        switch (c) {
            case 's':
                printf("\n");
                print_tr_stack();
                break;

            case 'c':
                return;

            case 't':
                if (trace_flag) {
                    trace_flag = 0;
                } else {
                    trace_flag = 1;
                }
                break;

            case '\r':
            case '\n':
                break;
        
            default:
                exit(1);
        }
    }
}

/*
 * Map of signal numbers to continuations
 */

struct cont_env * sig_cont[NSIG];

/*
 * Disable non-urgent signals
 */
int holdsigs()
{
    unsigned mask = 0xffffffff;

    if (sig_cont[SIGSEGV] == NULL_CE) {
	mask &= ~(1<<(SIGSEGV-1));
    }
    if (sig_cont[SIGILL] == NULL_CE) {
	mask &= ~(1<<(SIGILL-1));
    }
    if (sig_cont[SIGBUS] == NULL_CE) {
	mask &= ~(1<<(SIGBUS-1));
    }
    if (sig_cont[SIGQUIT] == NULL_CE) {
	mask &= ~(1<<(SIGQUIT-1));
    }
    if (sig_cont[SIGIOT] == NULL_CE) {
	mask &= ~(1<<(SIGIOT-1));
    }
    if (sig_cont[SIGEMT] == NULL_CE) {
	mask &= ~(1<<(SIGEMT-1));
    }
    if (sig_cont[SIGTRAP] == NULL_CE) {
	mask &= ~(1<<(SIGTRAP-1));
    }
    return(sigsetmask(mask));
}

void gc_init()
{
    word dummy;
#   define STACKTOP_ALIGNMENT_M1 0xffffff

    heaplim = (char *) (sbrk(0));
#   ifdef HBLK_MAP
	heapstart = (char *) (HBLKPTR(((unsigned)sbrk(0))+HBLKSIZE-1 ));
#   endif
#   ifdef STACKTOP
	stacktop = STACKTOP;
#   else
	stacktop = (word *)((((long)(&dummy)) + STACKTOP_ALIGNMENT_M1)
			    & ~STACKTOP_ALIGNMENT_M1);
#   endif
    hincr = HINCR;
    expand_hp(hincr);
    init_hblklist();
#   ifdef MERGE_SIZES
      init_size_map();
#   endif
}

