/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "types.h"

typedef long int arith ;

int charac ;
arith characl ;
int half_pos ;
int half_neg ;

field fd_zero = 0 ;
field fd_one = 1 ;
int field_size = sizeof(field) ;
 
init_charp(characteristic)
int characteristic ;
{
	charac = characteristic ;
	characl = charac ;
	if (charac IS 2) {
		half_pos = 1 ;
		half_neg = 0 ;
	} else {
		half_pos = (charac-1) / 2;
		half_neg = - half_pos ;
	}
}

field normalize(n)
arith n ;
{
	register field a ;

    a = n % charac ;
    if (a < half_neg) a += charac ;
    else if (a > half_pos) a -= charac ;
	return(a) ;
}
 
gcd_extended(a,b,u,v,g)
arith a, b ;
arith *u, *v, *g ;
{
    register arith q ;
    register arith u1, v1, g1;
    register arith utemp, vtemp, gtemp;
 
    g1 = b;     u1 = 0;         v1 = 1;
    *g = a;     *u = 1;         *v = 0;
    while (g1 ISNT 0)
        {
            q = *g / g1 ;
            gtemp=(*g) - q * g1;
            utemp=(*u) - q * u1;
            vtemp=(*v) - q * v1;
            *g = g1;            *u = u1;                *v = v1 ;
            g1 = gtemp;         u1 = utemp;             v1 = vtemp;
        }
}
 
 
lift(m,c,v2,v3)
int m ;
int c ;
int *v2, *v3 ;
{
	register arith vv2, vv3 ;
    register int u1, u2, u3, r1, r2, r3, v1 ;
    register int q ;
 
    vv3 = c;  	v1 = 0; 		vv2 = 1;
    u3 = m;     u1 = 1;         u2 = 0;
    while (2*(vv3)*(vv3) >= m)
        {
            q = u3 / (vv3) ;
            r3=(u3) - q * (vv3);
            r1=(u1) - q * v1;
            r2=(u2) - q * (vv2);
            u3 = vv3;         	u1 = v1;                u2 = vv2 ;
            vv3 = r3;         	v1 = r1;                vv2 = r2;
        }
    if (2*(vv2)*(vv2) >= m) (vv2) = 0 ;
	*v2 = vv2 ;
	*v3 = vv3 ;
}
 
fd_add(a,b,c)
field a, b, *c ;
{
	register arith val = a ;
	val += b ;
    *c = normalize(val) ;
}
 
fd_sub(a,b,c)
field a, b, *c ;
{
	register arith val = a ;
	val -= b ;
    *c = normalize(val) ;
}
 
fd_mult(a,b,c)
field a, b, *c ;
{
	register arith val = a ;
	val *= b ;
    *c = normalize(val) ;
}
 
fd_negate(a)
field *a ;
{
	register arith val = -(*a) ;
    *a = normalize(val) ;
}
 
fd_div(a,b,c)
field a, b, *c ;
{
	register arith bl = b ;
	register arith val ;
    arith binv, m, n ;
 
    gcd_extended(bl, characl, &binv, &m, &n) ;
	val = a * binv * n ; 	/* n = 1, or -1 */
    *c = normalize(val) ;
}
 
fd_recip(a)
field *a ;
{
	register arith al = *a ;
	register arith val ;
    arith ainv, m, n ;
 
    gcd_extended(al, characl, &ainv, &m, &n) ;
	val = ainv * n ;
    *a = normalize(val) ;
}
 
field fd_copy(a)
field a ;
{
    return(a) ;
}
 
boolean fd_iszero(a)
field a ;
{
    return(a IS 0) ;
}
