/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#ifdef USEDETACH
#include "style.h"
#include "signal.h"

#define sigA SIGFPE
#define sigB SIGIOT

char fname[] = "ttyfile" ;
int sendPID ;  /* used for sending signals from zombie process to orphan */
int zombiePID = 0 ; /* used to send KILL signal to zombie at exit time */

exitMacaulay()
{
  if (zombiePID ISNT 0)
    kill(zombiePID, SIGKILL) ;
  exit(0) ;
}

FILE *filOpen(s)
char *s ;  /* either "r" or "w" */
{
    FILE *fil, *topen() ;

    fil = topen(fname, s) ;
    if (fil IS NULL) {
      prerror("; can't open %s\n", fname) ;
      return(NULL) ;
    }
    return(fil) ;
}

wrTTY()
{
    FILE *fil ;

    fil = filOpen("w") ;
    if (fil IS NULL) return ;
    fprint(fil, "%d\n", getpid()) ;
    fprint(fil, "%s\n", ttyname(0)) ;
    fprint(fil, "%s\n", ttyname(1)) ;
    fprint(fil, "%s\n", ttyname(2)) ;
    fclose(fil) ;
}

int
rdPID()
{
  FILE *fil ;
  int n ;

  n = 0 ;
  fil = filOpen("r") ;
  fscanf(fil, "%d", &n) ;
  fclose(fil) ;
  return(n) ;
}

wrPID(n)
int n ;
{
  FILE *fil ;

  fil = filOpen("w") ;
  fprint(fil, "%d", n) ;
  fclose(fil) ;
}

int    /* returns pid in file */
attachTTY()
{
  FILE *fil ;
  char str[100] ;
  int pid, n ;

  fil = filOpen("r") ;

  n = fscanf(fil, "%d", &pid) ;
  if ((n IS 0) OR (n IS EOF)) return(0) ;
  fscanf(fil, "%99s", str) ;
  freopen(str, "r", stdin) ;
  fscanf(fil, "%99s", str) ;
  freopen(str, "w", stdout) ;
  fscanf(fil, "%99s", str) ;
  freopen(str, "w", stderr) ;
  fclose(fil) ;
  fil = filOpen("w") ;
  fclose(fil) ;
  return(pid) ;
}

orphanHandler()
{
  signal(sigA, SIG_IGN) ;
  zombiePID = attachTTY() ;
  if (zombiePID IS 0)
    prerror("; can't attach to Macaulay\n") ;
  else prerror("; just attached...\n") ;
}

doOrphan()
{
  signal(sigA, orphanHandler) ;
  prerror("; made it into orphan...\n") ;
}

sendINT() {  kill(sendPID, SIGINT) ; }
sendTERM() {  kill(sendPID, SIGTERM) ; exitMacaulay() ; }
sendCONT() { kill(sendPID, SIGCONT) ; }

doZombie(pid)
int pid ;
{
  sendPID = pid ;

  signal(SIGINT, sendINT) ;
  signal(SIGTERM, sendTERM) ;
  signal(SIGCONT, sendCONT) ;
}

wait_cmd()
{
  sigpause(0) ;
}

detach_cmd(argc, argv)
int argc ;
char *argv[] ;
{
  int pid ;

  if (argc > 2) {
    printnew("detach [output file]\n") ;
    return ;
  }
  signal(SIGHUP, SIG_IGN) ;
  pid = fork() ;
  if (pid IS 0) {
    if (argc > 1) freopen(argv[1], "w", stdout) ;
    doOrphan() ;
  } else {
    wrPID(pid) ;
    exitMacaulay() ;
  }
}

attach_cmd()
{
  int pid ;

  pid = rdPID() ;
  if (pid IS 0) {
    prerror("; can't attach to Macaulay\n") ;
    return ;
  }
  wrTTY() ;
  doZombie(pid) ;
  kill(pid, sigA) ;
  while (TRUE) sigpause(0) ;
}

sighup_cmd()
{
  signal(SIGHUP, SIG_IGN) ;
  wrPID(getpid()) ;
  doOrphan() ;
}

#else

exitMacaulay()
{
    exit(0) ;
}

/*
wait_cmd() {}
detach_cmd() {}
attach_cmd() {}
sighup_cmd() {}
*/
#endif
