
/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#ifndef SPHINX_BIGRSA
#define SPHINX_BIGRSA

/* DigitLim is general buffer allocation size */

#ifndef DigitLim
#define DigitLim 50
#endif

#define PrimeSize 20
#define MaxPrimeBits   PrimeSize*BN_DIGIT_SIZE-2
#define MaxModulusBits 2*MaxPrimeBits-8

typedef struct {
	int nl,el,pl,ql,dpl,dql;

	BigNumDigit	n[PrimeSize*2];
	BigNumDigit	e[PrimeSize*2];
	BigNumDigit	nINV[PrimeSize*2];
	BigNumDigit	beta2n[PrimeSize*2];

	BigNumDigit	p[PrimeSize];
	BigNumDigit	q[PrimeSize];
	BigNumDigit	dp[PrimeSize];
	BigNumDigit	dq[PrimeSize];
	BigNumDigit	cr[PrimeSize];
	BigNumDigit	pINV[PrimeSize];
	BigNumDigit	qINV[PrimeSize];
	BigNumDigit	beta3p[PrimeSize];
	BigNumDigit	beta3q[PrimeSize];
	BigNumDigit	beta2p[PrimeSize];
	}  RSAKeyStorage ;	

typedef struct {
	int nl,el,pl,ql,dpl,dql;

	BigNumDigit	n[PrimeSize*2];
	BigNumDigit	e[PrimeSize*2];
	BigNumDigit	nINV[PrimeSize*2];
	BigNumDigit	beta2n[PrimeSize*2];
	}  RSAPublicKeyStorage ;	

#define PRIVATE_KEY_SIZE sizeof(RSAKeyStorage)
#define PUBLIC_KEY_SIZE sizeof(RSAPublicKeyStorage)

#endif

