/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cdb_gdbm/RCS/check_req_apdu.c,v $
 *
 *
 *  MODULE NAME:    check_req_apdu.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <netdb.h>
#include <sys/time.h>
#include <sys/file.h>
#include <ctype.h>
#include <syslog.h>
#include "SPHINX-types.h"
#include "cdc.h"
#include "cdc_db.h"
#include "BigNum.h"
#include "BigRSA.h"

#ifdef sun
#define strncasecmp      strncmp_support
#define strcasecmp       strcmp_support
#endif

static char enc_privkey[PRIVATE_KEY_SIZE];
static CertificateList  certiflist;

int check_req_apdu(cdc_domain, pkt, rpkt, debugflag)
char   *cdc_domain;
KTEXT  pkt, rpkt;
int    debugflag;
{
  int     status, certif_type, contentsize, cdc_domainlen, j, i;
  int     cdc_req_apdu_len, result, explicit, indx, cnum = 0;
  int     got_crosscertif, so_far_len;
  char    relativename[2*ANAME_SZ], walk_down_name[2*ANAME_SZ];
  char    fullname[FULLNAME_SZ];
  char    resolvefrom[FULLNAME_SZ];
  char  *flag_p, flag, *cp;
  CrossNameList  crossnames;
  struct type_SPHINX_CDCAPDU  *cdc_request;
  struct type_SPHINX_ListOfNames  *crossdomains;
  struct type_SPHINX_Certificate  *crosscertif;
  PE            cdc_req_apdu_pe;

  cdc_domainlen = strlen(cdc_domain);
  if (!(cdc_req_apdu_pe = ssdu2pe(pkt->dat, pkt->length, 0, &result))) {
    status = int_SPHINX_CDCStatus_decodeRequestError;
    build_error_res_apdu(rpkt, status, debugflag);
  }
  explicit = 1;
  if (decode_SPHINX_CDCAPDU(cdc_req_apdu_pe, explicit, &cdc_req_apdu_len, NULLCP, &cdc_request) == NOTOK) {
    status = int_SPHINX_CDCStatus_decodeRequestError;
    build_error_res_apdu(rpkt, status, debugflag);
  }
  switch (cdc_request->offset) {

/***************************************************************************/
    case type_SPHINX_CDCAPDU_readPrinLoginRequest :
      strcpy(fullname, rdn_to_str(cdc_request->un.readPrinLoginRequest->principal));
      if (strcasecmp(cdc_domain, fullname) == 0)  strcpy(relativename, ".");
      else {
	if (strncasecmp(cdc_domain, fullname, cdc_domainlen) != 0) {
	  if (debugflag) {
	    printf("request '%s' in domain '%s'\n", fullname, cdc_domain);
	    printf("illegal domain!\n");
	  }
	  status = int_SPHINX_CDCStatus_unrecognizedDomain;
	  build_error_res_apdu(rpkt, status, debugflag);
	  return(status);
	}
	strcpy(relativename, &fullname[cdc_domainlen+1]);
      }

      flag_p = bitstr2strb(cdc_request->un.readPrinLoginRequest->flags, &j);
      if (flag_p != NULL)
	syslog(LOG_INFO, "cdc_server : readPrinLoginRequest '%s' (unknown flag)", fullname);
      if (cdc_request->un.readPrinLoginRequest->logindata != NULL) {
/*
 *     SPX CDC doesn't support a login agent currently, therefore ignore
 *     logindata from request
 *
	syslog(LOG_INFO, "cdc_server : readPrinLoginRequest '%s' (unknown logindata)", fullname);
 */
      }

      indx = 0;
      bzero(enc_privkey, sizeof(enc_privkey));
if (debugflag) {
  printf("    rpkt is READ_PRIVKEY_REQ - %s;", relativename);
}
      status = cdb_read_entry(relativename, ENC_PRIVKEY_ATTRIB,
			      enc_privkey, &contentsize, &indx);
      /* always send a reply packet */
if (debugflag) {
  printf(" status is %d\n", status);
}
      if (status == CDB_SUCCESS) {
	status = 0;
	build_login_res_apdu(rpkt, status, enc_privkey, contentsize, debugflag);
      } else
	build_error_res_apdu(rpkt, int_SPHINX_CDCStatus_unrecognizedPrincipal, debugflag);

      break;

/***************************************************************************/
    case type_SPHINX_CDCAPDU_readPrinCertRequest :
      strcpy(fullname, rdn_to_str(cdc_request->un.readPrinCertRequest->principal));
      if (debugflag)
	printf("readCertRequest '%s'\n", fullname);
      flag_p = bitstr2strb(cdc_request->un.readPrinCertRequest->flags, &j);
      if (flag_p != NULL)
	syslog(LOG_INFO, "cdc_server : readPrinCertRequest '%s' (unknown flag)", fullname);
      if (cdc_request->un.readPrinCertRequest->index != 0)
	syslog(LOG_INFO, "cdc_server : readPrinCertRequest '%s' (unknown index)", fullname);

      if (cdc_request->un.readPrinCertRequest->resolveFrom != NULL) {
	strcpy(resolvefrom, rdn_to_str(cdc_request->un.readPrinCertRequest->resolveFrom));
      } else resolvefrom[0] = '\0';

      i = 0;
      crossdomains = cdc_request->un.readPrinCertRequest->crossDomains;
      if (crossdomains != NULL) {
	while (crossdomains != NULL) {
	  strcpy(crossnames.names[i],rdn_to_str(crossdomains->Name));
	  i++;
	  crossdomains = crossdomains->next;
	}
	crossnames.num = i;
      } else crossnames.num = 0;

      if (debugflag) {
	printf("num of crosscertifiers is %d ; resolvefrom is '%s'\n", crossnames.num, resolvefrom);
	for (i=0; i< crossnames.num; i++)
	  printf("  #%d is '%s'\n", i+1, crossnames.names[i]);
      }

      /*
       *  Initialize the target relativename
       */
      if (strcasecmp(cdc_domain, fullname) == 0)  strcpy(relativename, ".");
      else {
	if (strncasecmp(cdc_domain, fullname, cdc_domainlen) != 0) {
	  if (debugflag) {
	    printf("request '%s' in domain '%s'\n", fullname, cdc_domain);
	    printf("illegal domain!\n");
	  }
	  status = int_SPHINX_CDCStatus_unrecognizedDomain;
	  build_error_res_apdu(rpkt, status, debugflag);
	  return(status);
	}
	strcpy(relativename, &fullname[cdc_domainlen+1]);
      }
      
      if (debugflag)
        printf("target relativename is '%s'\n", relativename);

      /*
       *  Initialize the walk_down_name
       */
      if ((crossnames.num == 0) && (resolvefrom[0] == '\0')) {
        /*
         *  since resolvefrom name is NULL, initalize walk_down_name to be
         *  immediate supervisor of target relativename.  This gives 3
         *  possibilities :
         *     if relativename is "." (domain), then walk_down_name is ""
         *        since above the domain
         *     if relativename is "abc" (1st level in domain), then
         *        walk_down_name is domain name (which is ".")
         *     if relativename is "abc/xyz/..." (nth level in domain), then
         *        walk_down_name is the immediate supervisor
         */
        if (strcmp(relativename, ".") == 0)  strcpy(walk_down_name, "");
        else {
          strcpy(walk_down_name, relativename);
	  if ((cp = rindex(walk_down_name, '/')) != 0) *cp = '\0';
          else strcpy(walk_down_name, ".");
        }
      } else {
	if (resolvefrom[0] != '\0') {
	  /*
	   *  set the walk_down_name to be equal to resolvefrom name
	   */
	  if (strcasecmp(resolvefrom, cdc_domain) == 0)
	    strcpy(walk_down_name, ".");
	  else strcpy(walk_down_name, &resolvefrom[cdc_domainlen+1]);
	} else strcpy(walk_down_name, "");  /*  since crossnames.num != 0  */
      }

      if (debugflag)
	printf("walk_down_name is '%s'\n", walk_down_name);

      cnum = 0;
      got_crosscertif = 0;
      if (crossnames.num != 0) {
	indx = 0;
	certif_type = CERTIF_ATTRIB;
	do {
	  status = cdb_read_entry(".", certif_type,
				  certiflist.data[cnum], &certiflist.sz[cnum],
				  &indx);
if (debugflag)
  printf("***\n    rpkt is READ_CERTIF_REQ - %s ; status is %d\n", ".", status);
	  if (status == CDB_SUCCESS) {
	    crosscertif = (struct type_SPHINX_Certificate *)
	      decode_certif_aux(certiflist.data[cnum], certiflist.sz[cnum]);
	    if (crosscertif != NULL) {
	      for (i=0; i<crossnames.num; i++) {
		if (strcasecmp(crossnames.names[i],
			       rdn_to_str(crosscertif->cinfo->issuer)) == 0) {
		  if (debugflag)
		    printf("found cross certifier certif - '%s'\n", crossnames.names[i]);
		  got_crosscertif = 1;
		  cnum++;
                  strcpy(walk_down_name, ".");
		  break;
		}
	      }
	    }
	  }
	} while ((!got_crosscertif) && (indx != 0) && (status == CDB_SUCCESS));
      }

      if ((crossnames.num != 0) && (!got_crosscertif)) {
	/*
	 *  unable to find any cross certifs; so we don't want to walk
	 *  down any further.
	 */
	status = CDB_UNKNOWN_KEY;
      } else status = CDB_SUCCESS;  /*  init status for rest of tree walk */

      while ((strcasecmp(walk_down_name, relativename) != 0) && (cnum < 3) && (status == CDB_SUCCESS)) {
	/*
	 *  incremet walk_down_name
	 */
	if (strcmp(walk_down_name, ".") == 0) {
	  /*  go to next level down from domain  */
	  strcpy(walk_down_name, relativename);
	  if ((cp = index(walk_down_name, '/')) != 0) *cp = '\0';
	} else {
	  so_far_len = strlen(walk_down_name);
	  strcpy(walk_down_name, relativename);
	  if ((cp = index(&walk_down_name[so_far_len+1], '/')) != 0)
	    *cp = '\0';
	}

	indx = 0;
	certif_type = CERTIF_ATTRIB;
	status = cdb_read_entry(walk_down_name, certif_type,
				certiflist.data[cnum], &certiflist.sz[cnum],
				&indx);
if (debugflag)
  printf("***\n    rpkt is READ_CERTIF_REQ - %s ; status is %d\n", walk_down_name, status);
	if (status == CDB_SUCCESS)  cnum++;
      }

      /* always send a reply packet */
      if (status == CDB_SUCCESS) {
        certiflist.num = cnum;
	status = 0;
        if (debugflag)
	  printf("build certif response packet with %d cert\n", cnum);
	build_certif_res_apdu(rpkt, status, &certiflist, debugflag);
      } else
	build_error_res_apdu(rpkt, int_SPHINX_CDCStatus_unrecognizedPrincipal, debugflag);
      break;

/***************************************************************************/
    case type_SPHINX_CDCAPDU_readTACertRequest :
      indx = cdc_request->un.readTACertRequest->index;
      strcpy(fullname, rdn_to_str(cdc_request->un.readTACertRequest->principal));

      flag_p = bitstr2strb(cdc_request->un.readTACertRequest->flags, &j);
      if (flag_p != NULL)
	syslog(LOG_INFO, "cdc_server : readTACertRequest '%s' (unknown flag)", fullname);

      if (strcasecmp(cdc_domain, fullname) == 0)  strcpy(relativename, ".");
      else {
	if (strncasecmp(cdc_domain, fullname, cdc_domainlen) != 0) {
	  if (debugflag) {
	    printf("request '%s' in domain '%s'\n", fullname, cdc_domain);
	    printf("illegal domain!\n");
	  }
	  status = int_SPHINX_CDCStatus_unrecognizedDomain;
	  build_error_res_apdu(rpkt, status, debugflag);
	  return(status);
	}
	strcpy(relativename, &fullname[cdc_domainlen+1]);
      }
      cnum = 0;
      do {
	certif_type = TA_CERTIF_ATTRIB;
if (debugflag) {
  printf("    rpkt is READ_TA_CERTIF_REQ - %s, %d;", relativename, indx);
}
	status = cdb_read_entry(relativename, certif_type,
				certiflist.data[cnum], &certiflist.sz[cnum],
				&indx);
if (debugflag) {
  printf(" status is %d\n", status);
}
	if (status == CDB_SUCCESS) cnum++;
      } while ((indx != 0) && (cnum < 3) && (status == CDB_SUCCESS));

      /* always send a reply packet */
      if (cnum >0) {
	status = 0;
	certiflist.num = cnum;
	build_tacertif_res_apdu(rpkt, status, &certiflist, indx, debugflag);
      } else
	build_error_res_apdu(rpkt, int_SPHINX_CDCStatus_unrecognizedPrincipal, debugflag);
      break;

    default :
      break;
    }
  pe_free(cdc_req_apdu_pe);
  free_SPHINX_CDCAPDU(cdc_request);
  return(status);
}

cdb_hexdump(p, l)
char *p;
int l;
{
  int i;

  for (i=0; i<l; i++)  {
    if ((i>0) && (i%16 == 0))  printf("\n");
    printf(" %02x", (unsigned char ) p[i]);
  }
  printf("\n");
}
