/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cfile/RCS/ver_ctx_string.c,v $
 *
 *
 *  MODULE NAME:    ver_ctx_string.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <sys/param.h>
#include <ctype.h>
#include "cdc.h"

/*
 * This routine is used to generate the name of the file that holds
 * the user's cache of server contexts and associated session keys.
 *
 * If it is set, cdc_context_string contains the context file name.
 * Otherwise, the filename is constructed as follows:
 *
 */

static char ver_context_string[MAXPATHLEN] = "";

char *ver_ctx_string(key, localissuname, fullissuname)
char *key, *localissuname, *fullissuname;
{
  char md2_hash[16], byte_string[3], newfullissuname[FULLNAME_SZ];
  int  i, c, len;

  strcpy(newfullissuname, fullissuname);
  (void) sprintf(ver_context_string, "%s_%s_ctx_%s_",VERCTX_ROOT,key,localissuname);
  len = strlen(newfullissuname);
  for (i=0;i<len;i++) {
    c = newfullissuname[i];
    if (islower(c) != 0)  newfullissuname[i] = toupper(c);
  }
  RSA_MD2(newfullissuname, len, md2_hash);
  for (i=0;i<4;i++) {
    sprintf(byte_string,"%02x", (unsigned char) md2_hash[i]);
    strcat(ver_context_string, byte_string);
  }
  return ver_context_string;
}
